# Nesting

Types should be nested at most 1 level deep, and functions should be nested at most 2 levels deep.

## Non Triggering Examples

```swift
actor Example_0 {
    actor Example_1 {}
}
```

```swift
var example: Int {
    actor Example_0 {
        actor Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        actor Example_0 {
            actor Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    actor Example_1 {}
}
```

```swift
class Example_0 {
    class Example_1 {}
}
```

```swift
var example: Int {
    class Example_0 {
        class Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        class Example_0 {
            class Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    class Example_1 {}
}
```

```swift
struct Example_0 {
    struct Example_1 {}
}
```

```swift
var example: Int {
    struct Example_0 {
        struct Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        struct Example_0 {
            struct Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    struct Example_1 {}
}
```

```swift
enum Example_0 {
    enum Example_1 {}
}
```

```swift
var example: Int {
    enum Example_0 {
        enum Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        enum Example_0 {
            enum Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    enum Example_1 {}
}
```

```swift
func f_0() {
    func f_1() {
        func f_2() {}
    }
}
```

```swift
var example: Int {
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        func f_0() {
            func f_1() {
                func f_2() {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
switch example {
case .exampleCase:
    actor Example_0 {
        actor Example_1 {}
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    actor Example_0 {
        actor Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
exampleFunc(closure: {
    actor Example_0 {
        actor Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
})
```

```swift
switch example {
case .exampleCase:
    class Example_0 {
        class Example_1 {}
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    class Example_0 {
        class Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
exampleFunc(closure: {
    class Example_0 {
        class Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
})
```

```swift
switch example {
case .exampleCase:
    struct Example_0 {
        struct Example_1 {}
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    struct Example_0 {
        struct Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
exampleFunc(closure: {
    struct Example_0 {
        struct Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
})
```

```swift
switch example {
case .exampleCase:
    enum Example_0 {
        enum Example_1 {}
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    enum Example_0 {
        enum Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
}
```

```swift
exampleFunc(closure: {
    enum Example_0 {
        enum Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {}
        }
    }
})
```

```swift
actor Example_0 {
    protocol Example_1 {}
}
```

```swift
var example: Int {
    actor Example_0 {
        protocol Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        actor Example_0 {
            protocol Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    protocol Example_1 {}
}
```

```swift
class Example_0 {
    protocol Example_1 {}
}
```

```swift
var example: Int {
    class Example_0 {
        protocol Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        class Example_0 {
            protocol Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    protocol Example_1 {}
}
```

```swift
struct Example_0 {
    protocol Example_1 {}
}
```

```swift
var example: Int {
    struct Example_0 {
        protocol Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        struct Example_0 {
            protocol Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    protocol Example_1 {}
}
```

```swift
enum Example_0 {
    protocol Example_1 {}
}
```

```swift
var example: Int {
    enum Example_0 {
        protocol Example_1 {}
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        enum Example_0 {
            protocol Example_1 {}
        }
    }
}
```

```swift
extension Example_0 {
    protocol Example_1 {}
}
```

```swift
actor Example_0 {
    func f_0() {
        actor Example_1 {
            func f_1() {
                func f_2() {}
            }
        }
        protocol P {}
    }
}
```

```swift
actor Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            actor Example_1 {
                func f_1() {
                    func f_2() {}
                }
            }
            protocol P {}
        default:
            exampleFunc(closure: {
                actor Example_1 {
                    func f_1() {
                        func f_2() {}
                    }
                }
                protocol P {}
            })
        }
    }
}
```

```swift
class Example_0 {
    func f_0() {
        class Example_1 {
            func f_1() {
                func f_2() {}
            }
        }
        protocol P {}
    }
}
```

```swift
class Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            class Example_1 {
                func f_1() {
                    func f_2() {}
                }
            }
            protocol P {}
        default:
            exampleFunc(closure: {
                class Example_1 {
                    func f_1() {
                        func f_2() {}
                    }
                }
                protocol P {}
            })
        }
    }
}
```

```swift
struct Example_0 {
    func f_0() {
        struct Example_1 {
            func f_1() {
                func f_2() {}
            }
        }
        protocol P {}
    }
}
```

```swift
struct Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            struct Example_1 {
                func f_1() {
                    func f_2() {}
                }
            }
            protocol P {}
        default:
            exampleFunc(closure: {
                struct Example_1 {
                    func f_1() {
                        func f_2() {}
                    }
                }
                protocol P {}
            })
        }
    }
}
```

```swift
enum Example_0 {
    func f_0() {
        enum Example_1 {
            func f_1() {
                func f_2() {}
            }
        }
        protocol P {}
    }
}
```

```swift
enum Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            enum Example_1 {
                func f_1() {
                    func f_2() {}
                }
            }
            protocol P {}
        default:
            exampleFunc(closure: {
                enum Example_1 {
                    func f_1() {
                        func f_2() {}
                    }
                }
                protocol P {}
            })
        }
    }
}
```

```swift
//
// ignore_coding_keys: true
//

struct Outer {
    struct Inner {
        enum CodingKeys: String, CodingKey {
            case id
        }
    }
}

```

## Triggering Examples

```swift
actor Example_0 {
    actor Example_1 {
        ↓actor Example_2 {}
    }
}
```

```swift
var example: Int {
    actor Example_0 {
        actor Example_1 {
            ↓actor Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        actor Example_0 {
            actor Example_1 {
                ↓actor Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    actor Example_1 {
        ↓actor Example_2 {}
    }
}
```

```swift
class Example_0 {
    class Example_1 {
        ↓class Example_2 {}
    }
}
```

```swift
var example: Int {
    class Example_0 {
        class Example_1 {
            ↓class Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        class Example_0 {
            class Example_1 {
                ↓class Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    class Example_1 {
        ↓class Example_2 {}
    }
}
```

```swift
struct Example_0 {
    struct Example_1 {
        ↓struct Example_2 {}
    }
}
```

```swift
var example: Int {
    struct Example_0 {
        struct Example_1 {
            ↓struct Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        struct Example_0 {
            struct Example_1 {
                ↓struct Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    struct Example_1 {
        ↓struct Example_2 {}
    }
}
```

```swift
enum Example_0 {
    enum Example_1 {
        ↓enum Example_2 {}
    }
}
```

```swift
var example: Int {
    enum Example_0 {
        enum Example_1 {
            ↓enum Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        enum Example_0 {
            enum Example_1 {
                ↓enum Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    enum Example_1 {
        ↓enum Example_2 {}
    }
}
```

```swift
func f_0() {
    func f_1() {
        func f_2() {
            ↓func f_3() {}
        }
    }
}
```

```swift
var example: Int {
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        func f_0() {
            func f_1() {
                func f_2() {
                    ↓func f_3() {}
                }
            }
        }
    }
}
```

```swift
extension Example_0 {
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
switch example {
case .exampleCase:
    actor Example_0 {
        actor Example_1 {
            ↓actor Example_2 {}
        }
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    actor Example_0 {
        actor Example_1 {
            ↓actor Example_2 {}
        }
        }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
exampleFunc(closure: {
    actor Example_0 {
        actor Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
})
```

```swift
switch example {
case .exampleCase:
    class Example_0 {
        class Example_1 {
            ↓class Example_2 {}
        }
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    class Example_0 {
        class Example_1 {
            ↓class Example_2 {}
        }
        }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
exampleFunc(closure: {
    class Example_0 {
        class Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
})
```

```swift
switch example {
case .exampleCase:
    struct Example_0 {
        struct Example_1 {
            ↓struct Example_2 {}
        }
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    struct Example_0 {
        struct Example_1 {
            ↓struct Example_2 {}
        }
        }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
exampleFunc(closure: {
    struct Example_0 {
        struct Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
})
```

```swift
switch example {
case .exampleCase:
    enum Example_0 {
        enum Example_1 {
            ↓enum Example_2 {}
        }
    }
default:
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
var exampleClosure: () -> Void = {
    enum Example_0 {
        enum Example_1 {
            ↓enum Example_2 {}
        }
        }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
}
```

```swift
exampleFunc(closure: {
    enum Example_0 {
        enum Example_1 {}
    }
    func f_0() {
        func f_1() {
            func f_2() {
                ↓func f_3() {}
            }
        }
    }
})
```

```swift
actor Example_0 {
    actor Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
var example: Int {
    actor Example_0 {
        actor Example_1 {
            ↓protocol Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        actor Example_0 {
            actor Example_1 {
                ↓protocol Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    actor Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
class Example_0 {
    class Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
var example: Int {
    class Example_0 {
        class Example_1 {
            ↓protocol Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        class Example_0 {
            class Example_1 {
                ↓protocol Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    class Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
struct Example_0 {
    struct Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
var example: Int {
    struct Example_0 {
        struct Example_1 {
            ↓protocol Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        struct Example_0 {
            struct Example_1 {
                ↓protocol Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    struct Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
enum Example_0 {
    enum Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
var example: Int {
    enum Example_0 {
        enum Example_1 {
            ↓protocol Example_2 {}
        }
    }
    return 5
}
```

```swift
var example: Int = 5 {
    didSet {
        enum Example_0 {
            enum Example_1 {
                ↓protocol Example_2 {}
            }
        }
    }
}
```

```swift
extension Example_0 {
    enum Example_1 {
        ↓protocol Example_2 {}
    }
}
```

```swift
actor Example_0 {
    func f_0() {
        actor Example_1 {
            func f_1() {
                func f_2() {
                    ↓actor Example_2 {}
                    ↓func f_3() {}
                    ↓protocol P {}
                }
            }
        }
    }
}
```

```swift
actor Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            actor Example_1 {
                func f_1() {
                    func f_2() {
                        ↓actor Example_2 {}
                        ↓func f_3() {}
                        ↓protocol P {}
                    }
                }
            }
        default:
            exampleFunc(closure: {
                actor Example_1 {
                    func f_1() {
                        func f_2() {
                            ↓actor Example_2 {}
                            ↓func f_3() {}
                            ↓protocol P {}
                        }
                    }
                }
            })
        }
    }
}
```

```swift
class Example_0 {
    func f_0() {
        class Example_1 {
            func f_1() {
                func f_2() {
                    ↓class Example_2 {}
                    ↓func f_3() {}
                    ↓protocol P {}
                }
            }
        }
    }
}
```

```swift
class Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            class Example_1 {
                func f_1() {
                    func f_2() {
                        ↓class Example_2 {}
                        ↓func f_3() {}
                        ↓protocol P {}
                    }
                }
            }
        default:
            exampleFunc(closure: {
                class Example_1 {
                    func f_1() {
                        func f_2() {
                            ↓class Example_2 {}
                            ↓func f_3() {}
                            ↓protocol P {}
                        }
                    }
                }
            })
        }
    }
}
```

```swift
struct Example_0 {
    func f_0() {
        struct Example_1 {
            func f_1() {
                func f_2() {
                    ↓struct Example_2 {}
                    ↓func f_3() {}
                    ↓protocol P {}
                }
            }
        }
    }
}
```

```swift
struct Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            struct Example_1 {
                func f_1() {
                    func f_2() {
                        ↓struct Example_2 {}
                        ↓func f_3() {}
                        ↓protocol P {}
                    }
                }
            }
        default:
            exampleFunc(closure: {
                struct Example_1 {
                    func f_1() {
                        func f_2() {
                            ↓struct Example_2 {}
                            ↓func f_3() {}
                            ↓protocol P {}
                        }
                    }
                }
            })
        }
    }
}
```

```swift
enum Example_0 {
    func f_0() {
        enum Example_1 {
            func f_1() {
                func f_2() {
                    ↓enum Example_2 {}
                    ↓func f_3() {}
                    ↓protocol P {}
                }
            }
        }
    }
}
```

```swift
enum Example_0 {
    func f_0() {
        switch example {
        case .exampleCase:
            enum Example_1 {
                func f_1() {
                    func f_2() {
                        ↓enum Example_2 {}
                        ↓func f_3() {}
                        ↓protocol P {}
                    }
                }
            }
        default:
            exampleFunc(closure: {
                enum Example_1 {
                    func f_1() {
                        func f_2() {
                            ↓enum Example_2 {}
                            ↓func f_3() {}
                            ↓protocol P {}
                        }
                    }
                }
            })
        }
    }
}
```

```swift
        struct Outer {
            struct Inner {
                ↓enum CodingKeys: String, CodingKey {
                    case id
                }
            }
        }
```

```swift
//
// ignore_coding_keys: true
//

struct Outer {
    struct Inner {
        ↓enum Example: String, CodingKey {
            case id
        }
    }
}

```

```swift
//
// ignore_coding_keys: true
//

struct Outer {
  enum CodingKeys: String, CodingKey {
    case id
    ↓struct S {}
  }
}

```