# Type Body Length

Type bodies should not span too many lines

## Non Triggering Examples

```swift
//
// warning: 2
//

actor A {}

```

```swift
//
// warning: 2
//

class C {}

```

```swift
//
// warning: 2
//

enum E {}

```

```swift
//
// warning: 2
// excluded_types: []
//

extension E {}

```

```swift
//
// warning: 2
// excluded_types: []
//

protocol P {}

```

```swift
//
// warning: 2
//

struct S {}

```

```swift
//
// warning: 2
//

actor A {
    let x = 0
}

```

```swift
//
// warning: 2
//

class C {
    let x = 0
    // comments
    // will
    // be
    // ignored
}

```

```swift
//
// warning: 2
//

enum E {
    let x = 0
    // empty lines will be ignored


}

```

```swift
//
// warning: 2
//

protocol P {
    let x = 0
    let y = 1
    let z = 2
}

```

## Triggering Examples

```swift
//
// warning: 2
//

↓actor A {
    let x = 0
    let y = 1
    let z = 2
}

```

```swift
//
// warning: 2
//

↓class C {
    let x = 0
    let y = 1
    let z = 2
}

```

```swift
//
// warning: 2
//

↓enum E {
    let x = 0
    let y = 1
    let z = 2
}

```

```swift
//
// warning: 2
// excluded_types: []
//

↓extension E {
    let x = 0
    let y = 1
    let z = 2
}

```

```swift
//
// warning: 2
// excluded_types: []
//

↓protocol P {
    let x = 0
    let y = 1
    let z = 2
}

```

```swift
//
// warning: 2
//

↓struct S {
    let x = 0
    let y = 1
    let z = 2
}

```