# Unavailable Condition

Use #unavailable/#available instead of #available/#unavailable with an empty body.

## Non Triggering Examples

```swift
if #unavailable(iOS 13) {
  loadMainWindow()
}
```

```swift
if #available(iOS 9.0, *) {
  doSomething()
} else {
  legacyDoSomething()
}
```

```swift
if #available(macOS 11.0, *) {
   // Do nothing
} else if #available(macOS 10.15, *) {
   print("do some stuff")
}
```

## Triggering Examples

```swift
if ↓#available(iOS 14.0) {

} else {
  oldIos13TrackingLogic(isEnabled: ASIdentifierManager.shared().isAdvertisingTrackingEnabled)
}
```

```swift
if ↓#available(iOS 14.0) {
  // we don't need to do anything here
} else {
  oldIos13TrackingLogic(isEnabled: ASIdentifierManager.shared().isAdvertisingTrackingEnabled)
}
```

```swift
if ↓#available(iOS 13, *) {} else {
  loadMainWindow()
}
```

```swift
if ↓#unavailable(iOS 13) {
  // Do nothing
} else if i < 2 {
  loadMainWindow()
}
```