"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSemanticRoleElement = void 0;
// The axobject-query package doesn't have type definitions, but this is what we're using from it here
let axElements = null;
let axRoles = null;
// This function follows the lazy initialization pattern.
// Since this is a top-level module (it will be included via `require`), we do not need to
// initialize the `nonInteractiveElementRoleSchemas` until the function is called
// for the first time, so we will not take up the memory.
function isSemanticRoleElement(element, role, elementAttributes) {
    var _a;
    if (axElements === null || axRoles === null) {
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        const { AXObjectRoles, elementAXObjects } = require('axobject-query');
        axElements = elementAXObjects;
        axRoles = AXObjectRoles;
    }
    // elementAXObjects: HTML elements are mapped to their related AXConcepts concepts
    return Array.from((_a = axElements === null || axElements === void 0 ? void 0 : axElements.keys()) !== null && _a !== void 0 ? _a : []).some((htmlElement) => {
        var _a, _b;
        return htmlElement.name === element &&
            ((_a = htmlElement.attributes) !== null && _a !== void 0 ? _a : []).every((htmlElemAttr) => 
            // match every axElement html attributes to given elementAttributes
            elementAttributes.find((elemAttr) => htmlElemAttr.name === elemAttr.name &&
                htmlElemAttr.value === elemAttr.value)) &&
            (
            // aria- properties are covered by the element's semantic role
            (_b = axElements === null || axElements === void 0 ? void 0 : axElements.get(htmlElement)) === null || _b === void 0 ? void 0 : _b.find((roleName) => {
                var _a;
                // AXObjectRoles: AXObjects are mapped to their related ARIA concepts
                return (_a = axRoles === null || axRoles === void 0 ? void 0 : axRoles.get(roleName)) === null || _a === void 0 ? void 0 : _a.find((semanticRole) => semanticRole.name === role);
            }));
    });
}
exports.isSemanticRoleElement = isSemanticRoleElement;
