/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S116")
public class FieldNameCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S116";
    private static final String MESSAGE = "Rename this field \"%s\" to match the regular expression %s.";
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    String format = "^[a-z][a-zA-Z0-9]*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS_PROPERTY_DECLARATION);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassPropertyDeclarationTree property = (ClassPropertyDeclarationTree)tree;
        for (VariableDeclarationTree variableDeclarationTree : property.declarations()) {
            String propertyName = variableDeclarationTree.identifier().text();
            if (this.pattern.matcher(StringUtils.remove(propertyName, "$")).matches()) continue;
            this.context().newIssue(this, variableDeclarationTree.identifier(), String.format(MESSAGE, propertyName, this.format));
        }
    }
}

