/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1451")
public class FileHeaderCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1451";
    private static final String MESSAGE = "Add or update the header of this file.";
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final Pattern PHP_OPEN_TAG = Pattern.compile("(?i)<\\?(?:php|=|)");
    @RuleProperty(key="headerFormat", defaultValue="", type="TEXT")
    public String headerFormat = "";
    private String[] expectedLines;

    @Override
    public void init() {
        this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        Iterator<String> it = CheckUtils.lines(this.context().getPhpFile()).iterator();
        if (it.hasNext() && !FileHeaderCheck.matches(this.expectedLines, it)) {
            this.context().newFileIssue(this, MESSAGE);
        }
    }

    private static boolean matches(String[] expectedLines, Iterator<String> lines) {
        String line = lines.next();
        if (PHP_OPEN_TAG.matcher(line).matches()) {
            if (lines.hasNext()) {
                line = lines.next();
            } else {
                return true;
            }
        }
        for (int i = 0; i < expectedLines.length; ++i) {
            String expectedLine;
            if (i > 0) {
                if (lines.hasNext()) {
                    line = lines.next();
                } else {
                    return false;
                }
            }
            if (line.equals(expectedLine = expectedLines[i])) continue;
            return false;
        }
        return true;
    }
}

