/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2047")
public class MethodNameReturningBooleanCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2047";
    private static final String MESSAGE = "Rename this method to start with \"is\" or \"has\".";
    private static final String RETURN_TAG = "@return";

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        super.visitMethodDeclaration(tree);
        if (MethodNameReturningBooleanCheck.isReturningBoolean(tree) && !MethodNameReturningBooleanCheck.hasBooleanPrefixName(tree)) {
            this.context().newIssue(this, tree.name(), MESSAGE);
        }
    }

    private static boolean hasBooleanPrefixName(MethodDeclarationTree methodDeclaration) {
        String methodName = methodDeclaration.name().text();
        return methodName.startsWith("has") || methodName.startsWith("is");
    }

    private static boolean isReturningBoolean(MethodDeclarationTree methodDeclaration) {
        for (SyntaxTrivia comment : ((PHPTree)((Object)methodDeclaration)).getFirstToken().trivias()) {
            for (String line : comment.text().split("\\n\\r\\u2028\\u2029")) {
                if (!StringUtils.containsIgnoreCase(line, RETURN_TAG)) continue;
                return MethodNameReturningBooleanCheck.returnsBoolean(line);
            }
        }
        return false;
    }

    private static boolean returnsBoolean(String line) {
        boolean isPreviousReturnTag = false;
        for (String word : line.split("\\s")) {
            String s = word.trim();
            if (RETURN_TAG.equals(s)) {
                isPreviousReturnTag = true;
                continue;
            }
            if (!isPreviousReturnTag) continue;
            return "bool".equalsIgnoreCase(s) || "boolean".equalsIgnoreCase(s);
        }
        return false;
    }
}

