/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="NoSonar")
public class NoSonarCheck
extends PHPVisitorCheck {
    public static final String KEY = "NoSonar";

    @Override
    public void visitTrivia(SyntaxTrivia trivia) {
        String[] commentLines;
        int startingLine = trivia.line();
        for (String commentLine : commentLines = trivia.text().split("(\r)?\n|\r")) {
            if (commentLine.contains("NOSONAR")) {
                this.context().newLineIssue(this, startingLine, "Is //NOSONAR used to exclude false-positive or to hide real quality flaw ?");
            }
            ++startingLine;
        }
        super.visitTrivia(trivia);
    }
}

