/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;

@Rule(key="S5915")
public class AssertionsAfterExceptionCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Don't perform an assertion here; An exception is expected to be raised before its execution.";
    private static final String MESSAGE_SINGLE = "Refactor this test; if this assertion's argument raises an exception, the assertion will never get executed.";
    private static final Set<String> EXPECT_METHODS = Set.of("expectexception", "expectexceptionmessage", "expectexceptionmessagematches", "exceptexceptioncode");
    private static final Set<String> EXPECT_ANNOTATIONS = Set.of("expectedexception", "expectexceptionmessage", "expectedexceptionmessage", "expectedexceptionmessageregexp");
    private FunctionCallTree expectExceptionCall;
    private FunctionCallTree lastFunctionCall;
    private boolean hasOtherFunctionCalls;
    private final Deque<FunctionCallTree> assertionsStack = new ArrayDeque<FunctionCallTree>();
    private Tree currentMethodBody;

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!this.isTestCaseMethod(tree)) {
            return;
        }
        this.expectExceptionCall = null;
        this.lastFunctionCall = null;
        this.hasOtherFunctionCalls = false;
        this.currentMethodBody = tree.body();
        super.visitMethodDeclaration(tree);
        if ((this.expectExceptionCall != null || AssertionsAfterExceptionCheck.hasExpectAnnotation(tree)) && this.lastFunctionCall != null && AssertionsAfterExceptionCheck.isAssertion(this.lastFunctionCall)) {
            this.newIssue(this.lastFunctionCall.callee(), this.hasOtherFunctionCalls ? MESSAGE : MESSAGE_SINGLE);
        }
    }

    private static boolean hasExpectAnnotation(MethodDeclarationTree tree) {
        for (String method : EXPECT_ANNOTATIONS) {
            if (!TreeUtils.hasAnnotation(tree, method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (!this.isPhpUnitTestMethod()) {
            return;
        }
        String functionName = CheckUtils.lowerCaseFunctionName(tree);
        if (functionName != null && EXPECT_METHODS.contains(functionName) && this.isMainStatementInBody(tree)) {
            this.expectExceptionCall = tree;
        } else if (AssertionsAfterExceptionCheck.isAssertion(tree)) {
            this.assertionsStack.add(tree);
        } else if (this.assertionsStack.isEmpty()) {
            this.hasOtherFunctionCalls = true;
        }
        super.visitFunctionCall(tree);
        this.lastFunctionCall = tree;
        if (AssertionsAfterExceptionCheck.isAssertion(tree)) {
            this.assertionsStack.pop();
        }
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.lastFunctionCall = null;
    }

    private boolean isMainStatementInBody(FunctionCallTree tree) {
        Objects.requireNonNull(tree.getParent());
        return tree.getParent().getParent() == this.currentMethodBody;
    }
}

