/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;

@Rule(key="S4784")
public class RegexUsageCheck
extends FunctionUsageCheck {
    private static final String MESSAGE = "Make sure that using a regular expression is safe here.";
    private static final Set<Character> SPECIAL_CHARS = Set.of(Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('{'));
    private static final int MIN_PATTERN_LENGTH = 7;
    private static final String MB_EREG_SEARCH_INIT = "mb_ereg_search_init";
    private static final Set<String> FUNCTION_NAMES = Set.of("ereg", "ereg_replace", "eregi", "eregi_replace", "fnmatch", "mb_ereg", "mb_ereg_match", "mb_ereg_replace", "mb_ereg_replace_callback", "mb_ereg_search", "mb_ereg_search_init", "mb_ereg_search_pos", "mb_ereg_search_regs", "mb_eregi", "mb_eregi_replace", "preg_filter", "preg_grep", "preg_match", "preg_match_all", "preg_replace", "preg_replace_callback", "preg_split", "split", "spliti");

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return FUNCTION_NAMES;
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        String value;
        int index = RegexUsageCheck.getPatternArgumentIndex(tree);
        Optional<CallArgumentTree> argument = CheckUtils.argument(tree, "pattern", index);
        if (argument.isEmpty()) {
            return;
        }
        ExpressionTree argumentValue = argument.get().value();
        if (argumentValue.is(Tree.Kind.REGULAR_STRING_LITERAL) && (value = ((LiteralTree)argumentValue).value()).length() >= 7 && RegexUsageCheck.hasEnoughNumberOfSpecialChars(value)) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private static int getPatternArgumentIndex(FunctionCallTree tree) {
        if (tree.callee().toString().equalsIgnoreCase(MB_EREG_SEARCH_INIT)) {
            return 1;
        }
        return 0;
    }

    private static boolean hasEnoughNumberOfSpecialChars(String value) {
        int numberOfSpecialChars = 0;
        for (char c : value.toCharArray()) {
            if (SPECIAL_CHARS.contains(Character.valueOf(c))) {
                ++numberOfSpecialChars;
            }
            if (numberOfSpecialChars != 2) continue;
            return true;
        }
        return false;
    }
}

