/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;

@Rule(key="S6339")
public class WordPressSaltsCheck
extends WordPressConfigVisitor {
    private static final String DEFAULT_VALUE_MESSAGE = "Using a default value is insecure.";
    private static final String SHORT_LENGTH_MESSAGE = "Using a short value is insecure.";
    private static final String EMPTY_MESSAGE = "Using an empty value is insecure.";
    private static final String DEFAULT_VALUE = "put your unique phrase here";
    private static final int MIN_LENGTH = 10;

    @Override
    protected Set<String> configsToVisit() {
        return new HashSet<String>(Arrays.asList("AUTH_KEY", "AUTH_SALT", "LOGGED_IN_KEY", "LOGGED_IN_SALT", "NONCE_KEY", "NONCE_SALT", "SECURE_AUTH_KEY", "SECURE_AUTH_SALT"));
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        WordPressSaltsCheck.configValue(config).filter(valueExpression -> valueExpression.is(Tree.Kind.REGULAR_STRING_LITERAL)).ifPresent(valueExpression -> this.checkValue(config, CheckUtils.trimQuotes(((LiteralTree)valueExpression).value())));
    }

    private void checkValue(FunctionCallTree defineTree, String value) {
        if (value.trim().isEmpty()) {
            this.context().newIssue(this, defineTree, EMPTY_MESSAGE);
        } else if (DEFAULT_VALUE.equalsIgnoreCase(value)) {
            this.context().newIssue(this, defineTree, DEFAULT_VALUE_MESSAGE);
        } else if (value.length() < 10) {
            this.context().newIssue(this, defineTree, SHORT_LENGTH_MESSAGE);
        }
    }
}

