/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public interface ISerializer<INTERNAL, EXTERNAL> {
    public @NonNull EXTERNAL serialize(@NonNull INTERNAL var1) throws StorageException;

    default public @NonNull List<EXTERNAL> serialize(Collection<@NonNull INTERNAL> values) throws StorageException {
        return CollectionUtils.mapWithException(values, this::serialize);
    }

    public @NonNull INTERNAL deserialize(@NonNull EXTERNAL var1) throws StorageException;

    default public @NonNull List<INTERNAL> deserialize(List<@NonNull EXTERNAL> value) throws StorageException {
        return CollectionUtils.mapWithException(value, this::deserialize);
    }

    default public <NEXT> ISerializer<INTERNAL, NEXT> andThen(final ISerializer<EXTERNAL, NEXT> next) {
        final ISerializer first = this;
        return new ISerializer<INTERNAL, NEXT>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public @NonNull List<INTERNAL> deserialize(List<@NonNull NEXT> value) throws StorageException {
                return first.deserialize(next.deserialize(value));
            }

            @Override
            public @NonNull INTERNAL deserialize(@NonNull NEXT value) throws StorageException {
                return first.deserialize(next.deserialize(value));
            }

            @Override
            public @NonNull List<NEXT> serialize(Collection<@NonNull INTERNAL> values) throws StorageException {
                return next.serialize(first.serialize(values));
            }

            @Override
            public @NonNull NEXT serialize(@NonNull INTERNAL value) throws StorageException {
                return next.serialize(first.serialize(value));
            }
        };
    }

    public static <INTERNAL, EXTERNAL> ISerializer<INTERNAL, EXTERNAL> of(final FunctionWithException<INTERNAL, EXTERNAL, ? extends StorageException> serialize, final FunctionWithException<EXTERNAL, INTERNAL, ? extends StorageException> deserialize) {
        Objects.requireNonNull(serialize, "serialize");
        Objects.requireNonNull(deserialize, "deserialize");
        return new ISerializer<INTERNAL, EXTERNAL>(){

            @Override
            public @NonNull EXTERNAL serialize(@NonNull INTERNAL value) throws StorageException {
                return serialize.apply(value);
            }

            @Override
            public @NonNull INTERNAL deserialize(@NonNull EXTERNAL value) throws StorageException {
                return deserialize.apply(value);
            }
        };
    }

    public static <INTERNAL, INTERMEDIATE, EXTERNAL> ISerializer<INTERNAL, EXTERNAL> mapping(ISerializer<INTERNAL, INTERMEDIATE> first, ISerializer<INTERMEDIATE, EXTERNAL> second) {
        return first.andThen(second);
    }

    public static ISerializer<Integer, byte[]> forInteger() {
        return ISerializer.of(ByteArrayUtils::intToByteArray, ByteArrayUtils::byteArrayToInt);
    }

    public static ISerializer<Long, byte[]> forLong() {
        return ISerializer.of(ByteArrayUtils::longToByteArray, ByteArrayUtils::byteArrayToLong);
    }

    public static <T extends Serializable> ISerializer<T, byte[]> forSerializable() {
        return ISerializer.of(StorageUtils::serialize, StorageUtils::deserialize);
    }

    public static <T extends Serializable> ISerializer<List<T>, byte[]> forSerializableList() {
        return ISerializer.forSerializableList(ArrayList::new);
    }

    public static <T extends Serializable, C extends List<T> & Serializable> ISerializer<List<T>, byte[]> forSerializableList(Function<List<T>, C> mapper) {
        return ISerializer.of(list -> {
            List selector0$temp = list;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Serializable.class}, (List)selector0$temp, index$1)) {
                case 0 -> {
                    Serializable serializable;
                    yield serializable = (Serializable)((Object)selector0$temp);
                }
                case -1 -> null;
                default -> (Serializable)((Object)((List)mapper.apply(list)));
            };
        }, List.class::cast).andThen(ISerializer.forSerializable());
    }

    public static ISerializer<String, byte[]> forString() {
        return ISerializer.of(StringUtils::stringToBytes, StringUtils::bytesToString);
    }

    public static <E extends Enum<E>> ISerializer<E, byte[]> forEnumOrdinal(Class<E> enumType) {
        Objects.requireNonNull(enumType, "enumType");
        Preconditions.checkArgument((boolean)enumType.isEnum(), (String)"Provided type %s is no enum", enumType);
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        return ISerializer.mapping(ISerializer.of(Enum::ordinal, ordinal -> {
            if (ordinal < 0 || ordinal >= enumConstants.length) {
                throw new StorageException("Deserialized ordinal (%d) is not available in enum class: %s".formatted(ordinal, enumType));
            }
            return enumConstants[ordinal];
        }), ISerializer.forInteger());
    }

    public static <T> ISerializer<T, T> identity() {
        return ISerializer.of(FunctionWithException.identity(), FunctionWithException.identity());
    }
}

