/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public final class UniformPathToValueIndex<T>
implements IUtilityIndex {
    private final IStore store;
    private final UniformPathSerializer keySerializer;
    private final ISerializer<T, byte[]> valueSerializer;

    private UniformPathToValueIndex(IStore store, UniformPathSerializer keySerializer, ISerializer<T, byte[]> valueSerializer) {
        this.store = Objects.requireNonNull(store, "store");
        this.keySerializer = Objects.requireNonNull(keySerializer, "keySerializer");
        this.valueSerializer = Objects.requireNonNull(valueSerializer, "valueSerializer");
    }

    public static <T> UniformPathToValueIndex<T> of(IStore store, UniformPathSerializer keySerializer, ISerializer<T, byte[]> valueSerializer) {
        return new UniformPathToValueIndex<T>(store, keySerializer, valueSerializer);
    }

    public static <T extends Serializable> UniformPathToValueIndex<T> of(IStore store) {
        return UniformPathToValueIndex.of(store, UniformPathSerializer.defaultSerializer(false), ISerializer.forSerializable());
    }

    public UniformPathSerializer getKeySerializer() {
        return this.keySerializer;
    }

    private void verifyPrefixQuerySupport() {
        if (!this.keySerializer.supportsPrefixQueries()) {
            throw new IllegalStateException("%s does not support prefix queries".formatted(this.keySerializer));
        }
    }

    private List<byte[]> serializeKeys(Collection<UniformPath> keys) throws StorageException {
        ArrayList<byte[]> result = new ArrayList<byte[]>(keys.size());
        for (UniformPath key : keys) {
            Objects.requireNonNull(key, "key");
            result.add((byte[])this.keySerializer.serialize(key));
        }
        return result;
    }

    private List<@Nullable T> deserializeValues(List<byte @Nullable []> values) throws StorageException {
        ArrayList<@Nullable T> result = new ArrayList<T>(values.size());
        for (byte[] value : values) {
            if (value == null) {
                result.add(null);
                continue;
            }
            result.add(this.valueSerializer.deserialize(value));
        }
        return result;
    }

    public Optional<T> getValue(UniformPath path) throws StorageException {
        Objects.requireNonNull(path, "path");
        byte[] value = this.store.get((byte[])this.keySerializer.serialize(path));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.valueSerializer.deserialize(value));
    }

    public List<@Nullable T> getValues(Collection<UniformPath> paths) throws StorageException {
        Objects.requireNonNull(paths, "paths");
        List<byte @Nullable []> values = this.store.get(this.serializeKeys(paths));
        return this.deserializeValues(values);
    }

    public Map<UniformPath, T> getExistingValues(Collection<UniformPath> paths) throws StorageException {
        HashMap<UniformPath, Object> result = new HashMap<UniformPath, Object>();
        for (Pair keyValue : CollectionUtils.zip(paths, this.getValues(paths))) {
            if (keyValue.getSecond() == null) continue;
            result.put((UniformPath)keyValue.getFirst(), keyValue.getSecond());
        }
        return result;
    }

    public void setValue(UniformPath path, T value) throws StorageException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(value, "value");
        this.store.put((byte[])this.keySerializer.serialize(path), this.valueSerializer.serialize(value));
    }

    public void setValues(PairList<UniformPath, T> keysAndValues) throws StorageException {
        PairList serializedKeysAndValues = new PairList(keysAndValues.size());
        for (Pair keyAndValue : keysAndValues) {
            serializedKeysAndValues.add((Object)((byte[])this.keySerializer.serialize((UniformPath)keyAndValue.getFirst())), (Object)this.valueSerializer.serialize(keyAndValue.getSecond()));
        }
        this.store.put((PairList<byte[], byte[]>)serializedKeysAndValues);
    }

    public void setValues(Map<UniformPath, T> keysAndValues) throws StorageException {
        PairList serializedKeysAndValues = new PairList(keysAndValues.size());
        for (Map.Entry<UniformPath, T> keyAndValue : keysAndValues.entrySet()) {
            serializedKeysAndValues.add((Object)((byte[])this.keySerializer.serialize(keyAndValue.getKey())), (Object)this.valueSerializer.serialize(keyAndValue.getValue()));
        }
        this.store.put((PairList<byte[], byte[]>)serializedKeysAndValues);
    }

    public void removeValue(UniformPath path) throws StorageException {
        Objects.requireNonNull(path, "path");
        this.store.remove((byte[])this.keySerializer.serialize(path));
    }

    public void removeValues(Collection<UniformPath> paths) throws StorageException {
        Objects.requireNonNull(paths, "paths");
        this.store.remove(this.serializeKeys(paths));
    }

    public void removeEntriesStartingWith(UniformPath path) throws StorageException {
        Objects.requireNonNull(path, "path");
        this.verifyPrefixQuerySupport();
        this.store.removeByPrefix((byte[])this.keySerializer.serialize(path));
    }

    public void clear() throws StorageException {
        StorageUtils.clearStore(this.store);
    }

    public Set<UniformPath> getAllKeys() throws StorageException {
        return this.getKeysStartingWith(new byte[0]);
    }

    public Set<UniformPath> getKeysStartingWith(UniformPath path) throws StorageException {
        Objects.requireNonNull(path, "path");
        this.verifyPrefixQuerySupport();
        return this.getKeysStartingWith((byte[])this.keySerializer.serialize(path));
    }

    private Set<UniformPath> getKeysStartingWith(byte[] prefix) throws StorageException {
        KeyDeserializingAndCollectingCallback callback = new KeyDeserializingAndCollectingCallback(this);
        this.store.scanKeys(prefix, (IKeyValueCallback)callback);
        return callback.getCollectedKeys();
    }

    public Map<UniformPath, T> getAllEntries() throws StorageException {
        return this.getEntriesStartingWith(new byte[0]);
    }

    public Map<UniformPath, T> getEntriesStartingWith(UniformPath path) throws StorageException {
        Objects.requireNonNull(path, "path");
        this.verifyPrefixQuerySupport();
        return this.getEntriesStartingWith((byte[])this.keySerializer.serialize(path));
    }

    private Map<UniformPath, T> getEntriesStartingWith(byte[] prefix) throws StorageException {
        KeyValueDeserializingAndCollectingCallback callback = new KeyValueDeserializingAndCollectingCallback(this);
        this.store.scan(prefix, (IKeyValueCallback)callback);
        return callback.getCollectedKeysAndValues();
    }

    public Set<UniformPath> getContainedKeys(Collection<UniformPath> paths) throws StorageException {
        Objects.requireNonNull(paths, "paths");
        List<byte @Nullable []> values = this.store.get(this.serializeKeys(paths));
        HashSet<UniformPath> result = new HashSet<UniformPath>();
        for (Pair uniformPathPair : CollectionUtils.zip(paths, values)) {
            if (uniformPathPair.getSecond() == null) continue;
            result.add((UniformPath)uniformPathPair.getFirst());
        }
        return result;
    }

    @Override
    public IStore getWrappedStore() {
        return this.store;
    }

    public String toString() {
        return "UniformPathValueIndex{keySerializer=" + String.valueOf(this.keySerializer) + "}";
    }

    @ThreadSafe
    private final class KeyDeserializingAndCollectingCallback
    extends UnsynchronizedExceptionHandlingCallbackBase {
        private final Set<UniformPath> collectedKeys;
        final /* synthetic */ UniformPathToValueIndex this$0;

        private KeyDeserializingAndCollectingCallback(UniformPathToValueIndex uniformPathToValueIndex) {
            UniformPathToValueIndex uniformPathToValueIndex2 = uniformPathToValueIndex;
            Objects.requireNonNull(uniformPathToValueIndex2);
            this.this$0 = uniformPathToValueIndex2;
            this.collectedKeys = ConcurrentHashMap.newKeySet();
        }

        @Override
        protected void callbackWithException(byte[] key, byte @Nullable [] value) throws StorageException {
            this.collectedKeys.add((UniformPath)this.this$0.keySerializer.deserialize(key));
        }

        public Set<UniformPath> getCollectedKeys() throws StorageException {
            this.throwCaughtException();
            return this.collectedKeys;
        }
    }

    @ThreadSafe
    private final class KeyValueDeserializingAndCollectingCallback
    extends UnsynchronizedExceptionHandlingCallbackBase {
        private final ConcurrentMap<UniformPath, T> collectedKeysAndValues;
        final /* synthetic */ UniformPathToValueIndex this$0;

        private KeyValueDeserializingAndCollectingCallback(UniformPathToValueIndex uniformPathToValueIndex) {
            UniformPathToValueIndex uniformPathToValueIndex2 = uniformPathToValueIndex;
            Objects.requireNonNull(uniformPathToValueIndex2);
            this.this$0 = uniformPathToValueIndex2;
            this.collectedKeysAndValues = new ConcurrentHashMap();
        }

        @Override
        protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
            this.collectedKeysAndValues.put((UniformPath)this.this$0.keySerializer.deserialize(key), this.this$0.valueSerializer.deserialize(Objects.requireNonNull(value, "value")));
        }

        public Map<UniformPath, T> getCollectedKeysAndValues() throws StorageException {
            this.throwCaughtException();
            return this.collectedKeysAndValues;
        }
    }

    @ThreadSafe
    private static abstract class UnsynchronizedExceptionHandlingCallbackBase
    implements IKeyValueCallback {
        private final AtomicReference<StorageException> exceptionHolder = new AtomicReference();

        private UnsynchronizedExceptionHandlingCallbackBase() {
        }

        @Override
        public final void callback(byte[] key, byte @Nullable [] value) {
            if (this.exceptionHolder.get() != null) {
                return;
            }
            try {
                this.callbackWithException(key, value);
            }
            catch (StorageException e) {
                this.exceptionHolder.compareAndSet(null, e);
            }
        }

        protected abstract void callbackWithException(byte[] var1, byte @Nullable [] var2) throws StorageException;

        protected final void throwCaughtException() throws StorageException {
            StorageException exception = this.exceptionHolder.get();
            if (exception != null) {
                throw new StorageException((Throwable)((Object)exception));
            }
        }
    }
}

