/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.KeyedObjectIndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

public abstract class UnbranchedKeyedObjectIndexBase<T>
extends KeyedObjectIndexBase<T>
implements IRollbackableIndex {
    private static final Logger LOGGER = LogManager.getLogger();

    protected UnbranchedKeyedObjectIndexBase(IStore store, IKeyedObjectDescriber<T> describer) {
        super(store, describer);
    }

    @Override
    public T getById(String id) throws StorageException {
        return this.getById(id, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public Set<String> getAllIds() throws StorageException {
        return this.getAllIds(0x7FFFFFFFFFFFFFFEL);
    }

    public Set<String> getAllIds(long timestamp) throws StorageException {
        return this.scanAll(timestamp).getIds();
    }

    public Map<String, Long> getAllIdsAndTimestamps(long timestamp) throws StorageException {
        return this.scanAll(timestamp).getIdsAndTimestamps();
    }

    private AllIdsCollectingCallback scanAll(long timestamp) throws StorageException {
        AllIdsCollectingCallback callback = new AllIdsCollectingCallback(this, timestamp);
        this.store.scan(OBJECT_PREFIX, (IKeyValueCallback)callback);
        return callback;
    }

    public T getById(String id, long timestamp) throws StorageException {
        NewestObjectExtractor collector = new NewestObjectExtractor(this);
        this.store.scan(this.createObjectKey(id, 0L), this.createObjectKey(id, UnbranchedKeyedObjectIndexBase.incrementTimestamp(timestamp)), collector);
        return collector.getNewestValue();
    }

    public void store(PairList<Long, T> timestampAndObjects) throws StorageException {
        CollectionUtils.sortByFirst(timestampAndObjects);
        UnbranchedObjectUpdateHelper objectUpdateHelper = new UnbranchedObjectUpdateHelper(this, this.getLookup());
        for (int i = 0; i < timestampAndObjects.size(); ++i) {
            try {
                this.storeObject(timestampAndObjects.getSecond(i), (Long)timestampAndObjects.getFirst(i), objectUpdateHelper);
                continue;
            }
            catch (IllegalStateException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        this.store.put(objectUpdateHelper.getKeysValues());
        this.storeMetaInformation(objectUpdateHelper.getAllKeys(), objectUpdateHelper.getAllValues());
    }

    public void removeIds(long timestamp, List<String> ids) throws StorageException {
        UnbranchedObjectUpdateHelper objectUpdateHelper = new UnbranchedObjectUpdateHelper(this, this.getLookup());
        this.removeIds(timestamp, ids, objectUpdateHelper);
    }

    private byte[] createObjectKey(String id, long timestamp) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{OBJECT_PREFIX, this.convertIdToBytes(id), SEPARATOR, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    @Override
    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) {
    }

    public Map<String, List<Long>> getLookup() throws StorageException {
        HashMap<String, List<Long>> lookup = new HashMap<String, List<Long>>();
        for (byte[] bytes : StorageUtils.listKeysStartingWith(OBJECT_PREFIX, (IStore)this.store)) {
            String objectId = UnbranchedKeyedObjectIndexBase.extractObjectId(bytes);
            long timestamp = UnbranchedKeyedObjectIndexBase.extractObjectTimestamp(bytes);
            lookup.computeIfAbsent(objectId, ignored -> new ArrayList()).add(timestamp);
        }
        for (List value : lookup.values()) {
            value.sort(Long::compare);
        }
        return lookup;
    }

    private static String extractObjectId(byte[] key) {
        return StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, OBJECT_PREFIX.length, key.length - 8 - SEPARATOR.length));
    }

    private static long extractObjectTimestamp(byte[] key) {
        return ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(key, key.length - 8, key.length));
    }

    @ThreadSafe
    private final class AllIdsCollectingCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private final Map<String, Long> itemToTimestamp;
        private final long endTimestamp;
        final /* synthetic */ UnbranchedKeyedObjectIndexBase this$0;

        private AllIdsCollectingCallback(UnbranchedKeyedObjectIndexBase unbranchedKeyedObjectIndexBase, long endTimestamp) {
            UnbranchedKeyedObjectIndexBase unbranchedKeyedObjectIndexBase2 = unbranchedKeyedObjectIndexBase;
            Objects.requireNonNull(unbranchedKeyedObjectIndexBase2);
            this.this$0 = unbranchedKeyedObjectIndexBase2;
            this.itemToTimestamp = new ConcurrentHashMap<String, Long>();
            this.endTimestamp = endTimestamp;
        }

        @Override
        public void callbackWithException(byte[] key, byte[] value) throws StorageException {
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(key, key.length - 8, key.length));
            if (timestamp > this.endTimestamp) {
                return;
            }
            String id = this.this$0.convertBytesToId(Arrays.copyOfRange(key, KeyedObjectIndexBase.OBJECT_PREFIX.length, key.length - 8 - KeyedObjectIndexBase.SEPARATOR.length));
            this.itemToTimestamp.compute(id, (ignored, existingTimestamp) -> {
                if (existingTimestamp != null && timestamp < existingTimestamp) {
                    return existingTimestamp;
                }
                return KeyedObjectIndexBase.isEmptyValue(value) ? null : Long.valueOf(timestamp);
            });
        }

        public Set<String> getIds() throws StorageException {
            this.throwCaughtException();
            return new HashSet<String>(this.itemToTimestamp.keySet());
        }

        public Map<String, Long> getIdsAndTimestamps() throws StorageException {
            this.throwCaughtException();
            return new HashMap<String, Long>(this.itemToTimestamp);
        }
    }

    @ThreadSafe
    private final class NewestObjectExtractor
    implements IKeyValueCallback {
        private long newestTimestamp;
        private byte[] newestValue;
        final /* synthetic */ UnbranchedKeyedObjectIndexBase this$0;

        private NewestObjectExtractor(UnbranchedKeyedObjectIndexBase unbranchedKeyedObjectIndexBase) {
            UnbranchedKeyedObjectIndexBase unbranchedKeyedObjectIndexBase2 = unbranchedKeyedObjectIndexBase;
            Objects.requireNonNull(unbranchedKeyedObjectIndexBase2);
            this.this$0 = unbranchedKeyedObjectIndexBase2;
            this.newestTimestamp = 0L;
            this.newestValue = null;
        }

        @Override
        public synchronized void callback(byte[] key, byte[] value) {
            byte[] timestampPart = Arrays.copyOfRange(key, key.length - 8, key.length);
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])timestampPart);
            if (timestamp > this.newestTimestamp) {
                this.newestTimestamp = timestamp;
                this.newestValue = value;
            }
        }

        public T getNewestValue() throws StorageException {
            return this.this$0.deserialize(this.newestValue);
        }
    }

    public class UnbranchedObjectUpdateHelper
    extends KeyedObjectIndexBase.ObjectUpdateHelper {
        private final Map<String, List<Long>> lookup;
        final /* synthetic */ UnbranchedKeyedObjectIndexBase this$0;

        private UnbranchedObjectUpdateHelper(UnbranchedKeyedObjectIndexBase this$0, Map<String, List<Long>> lookup) {
            UnbranchedKeyedObjectIndexBase unbranchedKeyedObjectIndexBase = this$0;
            Objects.requireNonNull(unbranchedKeyedObjectIndexBase);
            this.this$0 = unbranchedKeyedObjectIndexBase;
            super(this$0, this$0.getDescriber());
            this.lookup = lookup;
        }

        @Override
        protected T getOldObject(T object, long timestamp, String id) throws StorageException {
            List<Long> timestamps;
            Object oldObject = this.oldObjectCache.get(id);
            if (oldObject == null && !CollectionUtils.isNullOrEmpty(timestamps = this.lookup.get(id))) {
                long lastTimestamp;
                int index = Collections.binarySearch(timestamps, timestamp);
                if (index >= 0) {
                    lastTimestamp = timestamps.get(index);
                } else {
                    int insertionIndex = -(index + 1) - 1;
                    if (insertionIndex < 0) {
                        throw new IllegalStateException("Unable to determine old object for id '%s' and timestamp %d, because only values for later timestamps exist: %s".formatted(id, timestamp, timestamps));
                    }
                    lastTimestamp = timestamps.get(insertionIndex);
                }
                byte[] newestValue = this.this$0.store.get(this.this$0.createObjectKey(id, lastTimestamp));
                if (newestValue != null && !Arrays.equals(newestValue, KeyedObjectIndexBase.REMOVED_VALUE)) {
                    oldObject = this.describer.deserialize(newestValue);
                }
            }
            this.oldObjectCache.put(id, object);
            return oldObject;
        }

        @Override
        public void storeObject(String id, long timestamp, byte[] value) throws StorageException {
            this.keysValues.add((Object)this.this$0.createObjectKey(id, timestamp), (Object)value);
        }
    }
}

