/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.base;

import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;

public class StoreWithAbbreviationSupport
extends DelegatingStore {
    private final IStorageAbbreviator abbreviator;

    public StoreWithAbbreviationSupport(IStore baseStore, IStorageAbbreviator abbreviator) {
        super(baseStore);
        this.abbreviator = Objects.requireNonNull(abbreviator, "abbreviator");
    }

    @Deprecated
    public StorageStringAbbreviator getStringAbbreviator() {
        return new StorageStringAbbreviator(this.abbreviator);
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        if (capability == IAbbreviationStoreCapability.class) {
            return Optional.of((IStoreCapability)capability.cast(new AbbreviationCapability(this.abbreviator)));
        }
        return super.getCapability(capability);
    }

    private record AbbreviationCapability(IStorageAbbreviator abbreviator) implements IAbbreviationStoreCapability
    {
    }
}

