/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.hist;

import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistorizingStoreBase;
import org.conqat.engine.persistence.store.hist.TimestampAwareKeyCollectorCallbackBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TimestampReadOnlyHistorizingStore
extends HistorizingStoreBase {
    private static final long[] SCAN_RANGES = new long[]{86400000L, 1382400000L, 22118400000L};
    private final byte[] timestampSuffix;
    private final List<byte[]> scanStartKeySuffixes = new ArrayList<byte[]>();
    private final byte[] scanEndTimestampSuffix;
    private static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = UnsignedBytes.lexicographicalComparator();

    public TimestampReadOnlyHistorizingStore(IStore delegate, long readTimestamp) {
        super(delegate);
        CCSMAssert.isTrue((readTimestamp > 0L ? 1 : 0) != 0, (String)"Timestamp must be positive!");
        this.timestampSuffix = ByteArrayUtils.longToByteArray((long)readTimestamp);
        for (long scanRange : SCAN_RANGES) {
            long startTimeStamp = readTimestamp - scanRange;
            if (startTimeStamp <= 0L) continue;
            this.scanStartKeySuffixes.add(ByteArrayUtils.longToByteArray((long)startTimeStamp));
        }
        this.scanEndTimestampSuffix = ByteArrayUtils.longToByteArray((long)(readTimestamp + 1L));
    }

    @Override
    public byte[] get(byte @NonNull [] originalKey) throws StorageException {
        byte[] rawKey = this.getRawKey(originalKey);
        if (rawKey == null) {
            return null;
        }
        byte[] value = this.store.get(rawKey);
        if (HistorizingStoreBase.isDeletionValue(value)) {
            return null;
        }
        return value;
    }

    private byte[] getRawKey(final byte[] originalKey) throws StorageException {
        TimestampAwareKeyCollectorCallbackBase callback = new TimestampAwareKeyCollectorCallbackBase(this, this.timestampSuffix){
            {
                Objects.requireNonNull(this$0);
                super(timestampSuffix);
            }

            @Override
            public boolean isIncludedKey(byte[] key) {
                return Arrays.equals(key, originalKey);
            }
        };
        byte[] lastEndKey = TimestampReadOnlyHistorizingStore.revisionKey(originalKey, this.scanEndTimestampSuffix);
        for (byte[] startKeySuffix : this.scanStartKeySuffixes) {
            byte[] startKey = TimestampReadOnlyHistorizingStore.revisionKey(originalKey, startKeySuffix);
            this.store.scanKeys(startKey, lastEndKey, callback);
            if (callback.hasResult(originalKey)) {
                return callback.getRawKey(originalKey);
            }
            lastEndKey = startKey;
        }
        this.store.scanKeys(TimestampReadOnlyHistorizingStore.makeScanPrefix(originalKey), lastEndKey, callback);
        return callback.getRawKey(originalKey);
    }

    private static byte[] makeScanPrefix(byte[] key) {
        byte[] result = Arrays.copyOf(key, key.length + 1);
        result[key.length] = -2;
        return result;
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (byte[] key : keys) {
            result.add(this.get(key));
        }
        return result;
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        TimestampAwareKeyCollectorCallbackBase collector = this.createPrefixCollector(beginKey, endKey);
        this.store.scanKeys(beginKey, endKey, collector);
        this.reportNonDeletedValues(collector, callback);
    }

    @Override
    public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        TimestampAwareKeyCollectorCallbackBase collector = this.createPrefixCollector(prefix);
        this.store.scanKeys(prefix, (IKeyValueCallback)collector);
        this.reportNonDeletedValues(collector, callback);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        List collectors = CollectionUtils.map(prefixes, this::createPrefixCollector);
        this.store.scanKeys(prefixes, collectors);
        for (int i = 0; i < collectors.size(); ++i) {
            this.reportNonDeletedValues((TimestampAwareKeyCollectorCallbackBase)collectors.get(i), callbacks.get(i));
        }
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        if (beginKey == null) {
            beginKey = new byte[]{};
        }
        this.scan(beginKey, endKey, callback);
    }

    @Override
    public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        this.scan(prefix, callback);
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        this.scan(prefixes, callbacks);
    }

    private void reportNonDeletedValues(TimestampAwareKeyCollectorCallbackBase collector, IKeyValueCallback callback) throws StorageException {
        List<byte[]> rawKeys = collector.getRawKeys();
        List<byte[]> values = this.store.get(rawKeys);
        for (int i = 0; i < values.size(); ++i) {
            byte[] value = values.get(i);
            if (HistorizingStoreBase.isDeletionValue(value)) continue;
            callback.callback(HistorizingStoreBase.stripTimestampSuffix(rawKeys.get(i)), value);
        }
    }

    private TimestampAwareKeyCollectorCallbackBase createPrefixCollector(byte[] prefix) {
        return this.createPrefixCollector(Collections.singletonList(prefix));
    }

    private TimestampAwareKeyCollectorCallbackBase createPrefixCollector(final List<byte[]> prefixes) {
        return new TimestampAwareKeyCollectorCallbackBase(this, this.timestampSuffix){
            {
                Objects.requireNonNull(this$0);
                super(timestampSuffix);
            }

            @Override
            public boolean isIncludedKey(byte[] key) {
                for (byte[] prefix : prefixes) {
                    if (!ByteArrayUtils.isPrefix((byte[])prefix, (byte[])key)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private TimestampAwareKeyCollectorCallbackBase createPrefixCollector(final byte[] beginKey, final byte[] endKey) {
        return new TimestampAwareKeyCollectorCallbackBase(this, this.timestampSuffix){
            {
                Objects.requireNonNull(this$0);
                super(timestampSuffix);
            }

            @Override
            public boolean isIncludedKey(byte[] key) {
                return BYTE_ARRAY_COMPARATOR.compare(beginKey, key) < 1 && BYTE_ARRAY_COMPARATOR.compare(key, endKey) < 0;
            }
        };
    }
}

