/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.profiler;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemProviderBase;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class StorageProfiler
implements IStorageSystemProviderDecorator {
    private long nanoSeconds = 0L;
    private int numberOfCalls = 0;

    public long getTimeMillis() {
        return StorageProfiler.toMilliseconds(this.nanoSeconds);
    }

    protected static long toMilliseconds(long nanoSeconds) {
        return (nanoSeconds + 500000L) / 1000L / 1000L;
    }

    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    protected void reportTime(long startNanos) {
        this.nanoSeconds += System.nanoTime() - startNanos;
        ++this.numberOfCalls;
    }

    @Override
    public IStorageSystemProvider decorate(IStorageSystemProvider mainStorageSystemProvider) {
        return new DelegatingStorageSystemProviderBase(this, mainStorageSystemProvider){
            final /* synthetic */ StorageProfiler this$0;
            {
                StorageProfiler storageProfiler = this$0;
                Objects.requireNonNull(storageProfiler);
                this.this$0 = storageProfiler;
                super(storageSystemProvider);
            }

            @Override
            protected IStore wrapStore(IStore store, String storeName, String storageSystemName) {
                return new ProfilingStore(this.this$0, store);
            }
        };
    }

    protected class ProfilingStore
    implements IStore {
        private final IStore store;
        final /* synthetic */ StorageProfiler this$0;

        public ProfilingStore(StorageProfiler this$0, IStore store) {
            StorageProfiler storageProfiler = this$0;
            Objects.requireNonNull(storageProfiler);
            this.this$0 = storageProfiler;
            this.store = store;
        }

        @Override
        public byte[] get(byte @NonNull [] key) throws StorageException {
            long start = System.nanoTime();
            byte[] result = this.store.get(key);
            this.this$0.reportTime(start);
            return result;
        }

        @Override
        public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
            long start = System.nanoTime();
            List<byte[]> result = this.store.get(keys);
            this.this$0.reportTime(start);
            return result;
        }

        @Override
        public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
            long start = System.nanoTime();
            this.store.put(key, value);
            this.this$0.reportTime(start);
        }

        @Override
        public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
            long start = System.nanoTime();
            this.store.put(keysValues);
            this.this$0.reportTime(start);
        }

        @Override
        public void remove(byte @NonNull [] key) throws StorageException {
            long start = System.nanoTime();
            this.store.remove(key);
            this.this$0.reportTime(start);
        }

        @Override
        public void remove(List<byte @NonNull []> keys) throws StorageException {
            long start = System.nanoTime();
            this.store.remove(keys);
            this.this$0.reportTime(start);
        }

        @Override
        public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
            long start = System.nanoTime();
            this.store.removeByPrefix(prefix);
            this.this$0.reportTime(start);
        }

        @Override
        public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            this.store.scan(beginKey, endKey, callback);
            this.this$0.reportTime(start);
        }

        @Override
        public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            this.store.scan(prefix, callback);
            this.this$0.reportTime(start);
        }

        @Override
        public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
            long start = System.nanoTime();
            this.store.scan(prefixes, callbacks);
            this.this$0.reportTime(start);
        }

        @Override
        public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            this.store.scanKeys(beginKey, endKey, callback);
            this.this$0.reportTime(start);
        }

        @Override
        public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            this.store.scanKeys(prefix, callback);
            this.this$0.reportTime(start);
        }

        @Override
        public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
            long start = System.nanoTime();
            this.store.scanKeys(prefixes, callbacks);
            this.this$0.reportTime(start);
        }

        @Override
        public Lock obtainLock(String suffix) {
            return this.store.obtainLock(suffix);
        }

        @Override
        public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
            return this.store.getCapability(capability);
        }
    }
}

