/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.sharded;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.ICompactionCapability;
import org.conqat.engine.persistence.store.capability.IPeriodicMaintenanceCapability;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.engine.persistence.store.capability.IStorageInfoCapability;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.capability.RemovalCostCapability;
import org.conqat.engine.persistence.store.sharded.IShardingStrategy;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;

public class ShardingStorageSystemProvider
implements IStorageSystemProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IShardingStrategy shardingStrategy;
    private final List<IStorageSystemProvider> shardProviders;

    public ShardingStorageSystemProvider(IShardingStrategy shardingStrategy, List<IStorageSystemProvider> shardProviders) {
        int shardCount = shardingStrategy.getShardCount();
        Preconditions.checkArgument((shardCount > 0 ? 1 : 0) != 0, (Object)"Expected positive shard count!");
        Preconditions.checkState((shardCount == shardProviders.size() ? 1 : 0) != 0, (Object)"Expected number of shard provided to be the same as the number of shards used by the strategy!");
        this.shardingStrategy = shardingStrategy;
        this.shardProviders = new ArrayList<IStorageSystemProvider>(shardProviders);
    }

    @Override
    public IStorageSystem openStorageSystem(String storageSystemName) throws StorageException {
        return this.shardProviders.get(this.shardingStrategy.getShardIndexForStorageSystemName(storageSystemName)).openStorageSystem(storageSystemName);
    }

    @Override
    public void removeStorageSystem(String storageSystemName) throws StorageException {
        this.shardProviders.get(this.shardingStrategy.getShardIndexForStorageSystemName(storageSystemName)).removeStorageSystem(storageSystemName);
    }

    @Override
    public void close() throws StorageException {
        for (IStorageSystemProvider shardProvider : this.shardProviders) {
            shardProvider.close();
        }
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        if (capability == IPeriodicMaintenanceCapability.class) {
            return Optional.of(new ShardedMaintenanceCapability(this));
        }
        if (capability == IStorageInfoCapability.class) {
            return Optional.of(new ShardedInfoCapability(this));
        }
        if (capability == ICompactionCapability.class) {
            return Optional.of(new ShardedCompactionCapability(this));
        }
        if (capability == ISnapshotBackupCapability.class) {
            if (!this.allShardsSupportCapability(capability)) {
                return Optional.empty();
            }
            return Optional.of(new ShardedBackupCapability(this));
        }
        if (capability == RemovalCostCapability.class) {
            if (!this.allShardsSupportCapability(capability)) {
                return Optional.empty();
            }
            RemovalCostCapability removalCostCapability = this.getShardedRemovalCostCapability();
            return Optional.of(removalCostCapability);
        }
        LOGGER.warn("Capability check for {} not explicitly handled by shared storage system provider. This might indicate that support for this capability needs to be added for sharded storage systems. Please contact your Teamscale administrator.", capability);
        return Optional.empty();
    }

    private @NonNull RemovalCostCapability getShardedRemovalCostCapability() {
        List<RemovalCostCapability> removalCostCapabilities = this.getPresentShardCapabilities(RemovalCostCapability.class);
        Pair shardedRemovalCosts = new Pair((Object)true, (Object)true);
        for (RemovalCostCapability removalCost : removalCostCapabilities) {
            shardedRemovalCosts.setFirst((Object)((Boolean)shardedRemovalCosts.getFirst() != false && removalCost.storeRemovalCheap() ? 1 : 0));
            shardedRemovalCosts.setSecond((Object)((Boolean)shardedRemovalCosts.getSecond() != false && removalCost.storageSystemRemovalCheap() ? 1 : 0));
            if (!((Boolean)shardedRemovalCosts.getFirst()).equals(false) || !((Boolean)shardedRemovalCosts.getSecond()).equals(false)) continue;
            break;
        }
        return new RemovalCostCapability((Boolean)shardedRemovalCosts.getFirst(), (Boolean)shardedRemovalCosts.getSecond());
    }

    private boolean allShardsSupportCapability(Class<? extends IStorageSystemCapability> capability) {
        return this.shardProviders.stream().map(shardProvider -> shardProvider.getCapability(capability)).allMatch(Optional::isPresent);
    }

    private <T extends IStorageSystemCapability> List<T> getPresentShardCapabilities(Class<T> capability) {
        List capabilities = CollectionUtils.map(this.shardProviders, provider -> provider.getCapability(capability));
        return CollectionUtils.filterAndMap((Collection)capabilities, Optional::isPresent, Optional::get);
    }

    private final class ShardedMaintenanceCapability
    implements IPeriodicMaintenanceCapability {
        final /* synthetic */ ShardingStorageSystemProvider this$0;

        private ShardedMaintenanceCapability(ShardingStorageSystemProvider shardingStorageSystemProvider) {
            ShardingStorageSystemProvider shardingStorageSystemProvider2 = shardingStorageSystemProvider;
            Objects.requireNonNull(shardingStorageSystemProvider2);
            this.this$0 = shardingStorageSystemProvider2;
        }

        @Override
        public void performMaintenance(ICancelable cancelable) throws StorageException {
            for (IPeriodicMaintenanceCapability capability : this.this$0.getPresentShardCapabilities(IPeriodicMaintenanceCapability.class)) {
                if (cancelable.isCanceled()) {
                    return;
                }
                capability.performMaintenance(cancelable);
            }
        }
    }

    private final class ShardedInfoCapability
    implements IStorageInfoCapability {
        final /* synthetic */ ShardingStorageSystemProvider this$0;

        private ShardedInfoCapability(ShardingStorageSystemProvider shardingStorageSystemProvider) {
            ShardingStorageSystemProvider shardingStorageSystemProvider2 = shardingStorageSystemProvider;
            Objects.requireNonNull(shardingStorageSystemProvider2);
            this.this$0 = shardingStorageSystemProvider2;
        }

        @Override
        public String getStorageInfo() throws StorageException {
            StringBuilder builder = new StringBuilder("Sharding storage system provider\n\n");
            builder.append("Strategy: ").append(this.this$0.shardingStrategy.getClass().getSimpleName()).append("\n");
            for (int i = 0; i < this.this$0.shardingStrategy.getShardCount(); ++i) {
                builder.append("\n# Shard ").append(this.this$0.shardingStrategy.getShardDirectory(i)).append(":\n");
                Optional<IStorageInfoCapability> capability = this.this$0.shardProviders.get(i).getCapability(IStorageInfoCapability.class);
                if (capability.isPresent()) {
                    builder.append(capability.get().getStorageInfo());
                    continue;
                }
                builder.append("no info\n");
            }
            return builder.toString();
        }
    }

    private final class ShardedCompactionCapability
    implements ICompactionCapability {
        final /* synthetic */ ShardingStorageSystemProvider this$0;

        private ShardedCompactionCapability(ShardingStorageSystemProvider shardingStorageSystemProvider) {
            ShardingStorageSystemProvider shardingStorageSystemProvider2 = shardingStorageSystemProvider;
            Objects.requireNonNull(shardingStorageSystemProvider2);
            this.this$0 = shardingStorageSystemProvider2;
        }

        @Override
        public void runFullCompaction() throws StorageException {
            for (ICompactionCapability capability : this.this$0.getPresentShardCapabilities(ICompactionCapability.class)) {
                capability.runFullCompaction();
            }
        }
    }

    private final class ShardedBackupCapability
    implements ISnapshotBackupCapability {
        final /* synthetic */ ShardingStorageSystemProvider this$0;

        private ShardedBackupCapability(ShardingStorageSystemProvider shardingStorageSystemProvider) {
            ShardingStorageSystemProvider shardingStorageSystemProvider2 = shardingStorageSystemProvider;
            Objects.requireNonNull(shardingStorageSystemProvider2);
            this.this$0 = shardingStorageSystemProvider2;
        }

        @Override
        public void createSnapshotBackup(ISnapshotBackupCapability.ISnapshotConsumer snapshotConsumer) throws StorageException, IOException {
            for (ISnapshotBackupCapability capability : this.this$0.getPresentShardCapabilities(ISnapshotBackupCapability.class)) {
                capability.createSnapshotBackup(snapshotConsumer);
            }
        }
    }
}

