/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.transaction.TransactionalStorageSystem;
import org.conqat.lib.commons.factory.IFactory;

public class TransactionHandler {
    private final Map<String, TransactionalStorageSystem> openPartitions = new HashMap<String, TransactionalStorageSystem>();
    private final IFactory<IStore, StorageException> tempStoreCreator;
    private final StorageCacheProvider storageCacheProvider;

    public TransactionHandler(StorageCacheProvider storageCacheProvider, IFactory<IStore, StorageException> tempStoreCreator) {
        this.tempStoreCreator = tempStoreCreator;
        this.storageCacheProvider = storageCacheProvider;
    }

    public synchronized void commit() throws StorageException {
        for (TransactionalStorageSystem store : this.openPartitions.values()) {
            store.commit();
        }
    }

    public synchronized void rollback() throws StorageException {
        for (TransactionalStorageSystem store : this.openPartitions.values()) {
            store.rollback();
        }
    }

    public IStorageSystemProvider decorate(IStorageSystemProvider storageSystemProvider) {
        return new TransactionalStorageSystemProvider(this, storageSystemProvider);
    }

    private class TransactionalStorageSystemProvider
    implements IStorageSystemProvider {
        private final IStorageSystemProvider storageSystemProvider;
        final /* synthetic */ TransactionHandler this$0;

        public TransactionalStorageSystemProvider(TransactionHandler transactionHandler, IStorageSystemProvider storageSystemProvider) {
            TransactionHandler transactionHandler2 = transactionHandler;
            Objects.requireNonNull(transactionHandler2);
            this.this$0 = transactionHandler2;
            this.storageSystemProvider = storageSystemProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IStorageSystem openStorageSystem(String mainPartitionName) throws StorageException {
            TransactionHandler transactionHandler = this.this$0;
            synchronized (transactionHandler) {
                TransactionalStorageSystem partition = this.this$0.openPartitions.get(mainPartitionName);
                if (partition == null) {
                    partition = new TransactionalStorageSystem(this.storageSystemProvider.openStorageSystem(mainPartitionName), this.this$0.storageCacheProvider.getCacheProvider(mainPartitionName), this.this$0.tempStoreCreator);
                    this.this$0.openPartitions.put(mainPartitionName, partition);
                }
                return partition;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeStorageSystem(String projectName) throws StorageException {
            TransactionHandler transactionHandler = this.this$0;
            synchronized (transactionHandler) {
                this.this$0.openPartitions.remove(projectName);
                this.storageSystemProvider.removeStorageSystem(projectName);
                this.this$0.storageCacheProvider.invalidateCaches();
            }
        }

        @Override
        public void close() throws StorageException {
            this.storageSystemProvider.close();
        }

        @Override
        public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
            return this.storageSystemProvider.getCapability(capability);
        }
    }
}

