/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.xodus;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.management.Statistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.LocalLockProvider;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StorageSystemBase;
import org.conqat.engine.persistence.store.capability.ICompactionCapability;
import org.conqat.engine.persistence.store.capability.IStorageInfoCapability;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.capability.RemovalCostCapability;
import org.conqat.engine.persistence.store.util.StorageSystemIdManager;
import org.conqat.engine.persistence.store.xodus.XodusStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class XodusStorageSystemProvider
implements IStorageSystemProvider,
Thread.UncaughtExceptionHandler,
IStorageInfoCapability {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LOG_LOCK_TIMEOUT_MS_PROPERTY_NAME = "com.teamscale.storage.xodus.log-lock-timeout-ms";
    private static final int LOG_LOCK_TIMEOUT_MS = Integer.parseInt(System.getProperty("com.teamscale.storage.xodus.log-lock-timeout-ms", Integer.toString(5000)));
    private final Map<String, Environment> environmentMap = new ConcurrentHashMap<String, Environment>();
    private final File baseDir;
    private final int cacheSizeMB;
    private final int logFileSizeMB;
    public static final String LOG_FILE_SIZE_KEY = "log-file-size-mb";
    public static final int LOG_FILE_SIZE_DEFAULT_MB = 512;

    public XodusStorageSystemProvider(File dir, int cacheSizeMB, int logFileSizeMB) throws StorageException {
        StorageSystemBase.ensureStorageDirectoryExists(dir);
        this.baseDir = dir;
        this.cacheSizeMB = cacheSizeMB;
        this.logFileSizeMB = logFileSizeMB;
    }

    @Override
    public synchronized IStorageSystem openStorageSystem(String storageSystemName) {
        return new XodusStorageSystem(this, storageSystemName);
    }

    private static @NonNull String getEnvironmentId(String storageSystemName, String storeName) {
        return storageSystemName + "-" + storeName;
    }

    @Override
    public synchronized void removeStorageSystem(String storageSystemName) throws StorageException {
        StorageSystemIdManager.getInstance().removeStorageSystem(storageSystemName);
        for (String envName : this.environmentMap.keySet().stream().filter(id -> id.startsWith(storageSystemName + "-")).toList()) {
            Environment env = this.environmentMap.remove(envName);
            if (env == null) continue;
            XodusStorageSystemProvider.waitForPendingTransactionsAndClose(env);
            try {
                FileSystemUtils.deleteRecursively((Path)Paths.get(env.getLocation(), new String[0]));
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    private static void waitForPendingTransactionsAndClose(Environment env) {
        env.executeTransactionSafeTask(() -> env.executeInExclusiveTransaction(t -> env.close()));
    }

    @Override
    public void close() throws StorageException {
        try {
            for (Environment env : this.environmentMap.values()) {
                if (!env.isOpen()) continue;
                env.close();
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        if (capability == RemovalCostCapability.class) {
            return Optional.of(new RemovalCostCapability(true, true));
        }
        if (capability == IStorageInfoCapability.class || capability == ICompactionCapability.class) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable e) {
        LOGGER.atError().withThrowable(e).log("Had exception in database background thread {}: {}", (Object)thread.getName(), (Object)e.getMessage());
    }

    @Override
    public String getStorageInfo() {
        StringBuilder builder = new StringBuilder("Xodus Storage Backend\n");
        for (Map.Entry<String, Environment> entry : this.environmentMap.entrySet()) {
            Environment storeEnvironment = entry.getValue();
            builder.append("\nStats for storage system: ").append(entry.getKey()).append("=========================\n").append("\n");
            Statistics statistics = storeEnvironment.getStatistics();
            for (EnvironmentStatistics.Type e : EnvironmentStatistics.Type.values()) {
                builder.append(e.id).append(": ").append(statistics.getStatisticsItem((Enum)e).getTotal()).append(" (Mean: ").append(statistics.getStatisticsItem((Enum)e).getMean()).append(")\n");
            }
            builder.append("\nStores with number of entries:\n");
            storeEnvironment.executeInReadonlyTransaction(txn -> {
                for (String storeName : CollectionUtils.sort((Collection)storeEnvironment.getAllStoreNames(txn))) {
                    Store store = storeEnvironment.openStore(storeName, StoreConfig.USE_EXISTING, txn);
                    builder.append(storeName).append(": ").append(store.count(txn)).append("\n");
                }
            });
        }
        return builder.toString();
    }

    @VisibleForTesting
    public Environment getEnvironmentForStore(String storageSystemName, String storeName) {
        return this.environmentMap.get(XodusStorageSystemProvider.getEnvironmentId(storageSystemName, storeName));
    }

    @Override
    public void warmUpStorageSystem(InternalProjectId internalProjectId) throws StorageException {
        IStorageSystem projectStorageSystem = this.openStorageSystem(internalProjectId);
        IndexSchema schema = IndexSchema.load(projectStorageSystem, IndexSchemaCache.UNCACHED_ACCESS);
        CCSMAssert.isNotNull((Object)schema, (String)("Expecting schema to be present for storage system " + String.valueOf(internalProjectId)));
        for (String storeName : schema.getEntryNames()) {
            projectStorageSystem.openStore(storeName);
        }
    }

    private class XodusStorageSystem
    implements IStorageSystem {
        private static final String XODUS_ENV_MONITOR_TXNS_TIMEOUT_MS_PROPERTY = "com.teamscale.xodus.env-monitor.txns-timeout-ms";
        private final String storageSystemName;
        private final int storageSystemId;
        private final ILockProvider lockProvider;
        final /* synthetic */ XodusStorageSystemProvider this$0;

        private XodusStorageSystem(XodusStorageSystemProvider xodusStorageSystemProvider, String storageSystemName) {
            XodusStorageSystemProvider xodusStorageSystemProvider2 = xodusStorageSystemProvider;
            Objects.requireNonNull(xodusStorageSystemProvider2);
            this.this$0 = xodusStorageSystemProvider2;
            this.lockProvider = new LocalLockProvider();
            this.storageSystemName = storageSystemName;
            this.storageSystemId = StorageSystemIdManager.getInstance().getOrCreateId(this.storageSystemName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IStore openStore(String storeName) throws StorageException {
            String id = XodusStorageSystemProvider.getEnvironmentId(this.storageSystemName, storeName);
            if (!this.this$0.environmentMap.containsKey(id)) {
                Lock lock = this.lockProvider.obtainLock(XodusStorageSystem.getLockName(this.storageSystemName, storeName));
                try {
                    lock.lock();
                    if (!this.this$0.environmentMap.containsKey(id)) {
                        this.this$0.environmentMap.put(id, this.createEnvironment(id));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            return new XodusStore(this.this$0.environmentMap.get(id), this.lockProvider, storeName, this.storageSystemName);
        }

        @Override
        public void removeStore(String storeName) throws StorageException {
            Lock lock = this.lockProvider.obtainLock(XodusStorageSystem.getLockName(this.storageSystemName, storeName));
            try {
                lock.lock();
                String environmentId = XodusStorageSystemProvider.getEnvironmentId(this.storageSystemName, storeName);
                if (!this.this$0.environmentMap.containsKey(environmentId)) {
                    this.this$0.environmentMap.put(environmentId, this.createEnvironment(environmentId));
                }
                Environment environment = this.this$0.environmentMap.remove(environmentId);
                environment.getEnvironmentConfig().setGcEnabled(false);
                environment.close();
                File directory = new File(environment.getLocation());
                FileSystemUtils.deleteRecursively((File)directory);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            finally {
                lock.unlock();
            }
        }

        private Environment createEnvironment(String id) throws StorageException {
            Environment env;
            try {
                env = Environments.newInstance((File)new File(this.this$0.baseDir, id), (EnvironmentConfig)new EnvironmentConfig().setEnvMonitorTxnsTimeout(Integer.getInteger(XODUS_ENV_MONITOR_TXNS_TIMEOUT_MS_PROPERTY, 0).intValue()).setMemoryUsage(ByteUnit.MEBIBYTES.toBytes((long)this.this$0.cacheSizeMB)).setLogFileSize(ByteUnit.MEBIBYTES.toKibiBytes((long)this.this$0.logFileSizeMB)).setEnvCloseForcedly(true).setLogLockTimeout((long)LOG_LOCK_TIMEOUT_MS).setProfilerEnabled(false));
            }
            catch (RuntimeException e) {
                throw new StorageException(e);
            }
            env.executeInExclusiveTransaction(transaction -> env.openStore(id, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true));
            return env;
        }

        private static String getLockName(String storageSystemName, String storeName) {
            return "Store creation lock: " + storageSystemName + "/" + storeName;
        }

        @Override
        public int getStorageSystemId() {
            return this.storageSystemId;
        }
    }
}

