/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.xodus;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.log.TooBigLoggableException;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreBase;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public class XodusStore
extends StoreBase {
    private static final int MAX_TRANSACTION_ELEMENT_SIZE = 10000;
    private final ILockProvider lockProvider;
    private final String tableName;
    private final String storageSystemName;
    private final Environment storeEnvironment;
    private static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = UnsignedBytes.lexicographicalComparator();

    public XodusStore(Environment storeEnvironment, ILockProvider lockProvider, String tableName, String storageSystemName) {
        this.storeEnvironment = storeEnvironment;
        this.lockProvider = lockProvider;
        this.tableName = storageSystemName + "-" + tableName;
        this.storageSystemName = storageSystemName;
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        XodusStore.throwIfKeyIsNull(key);
        try {
            return (byte[])this.storeEnvironment.computeInReadonlyTransaction(transaction -> {
                Store store = this.storeEnvironment.openStore(this.tableName, StoreConfig.USE_EXISTING, transaction);
                @Nullable ByteIterable result = store.get(transaction, (ByteIterable)new ArrayByteIterable(key));
                transaction.abort();
                return XodusStore.getByteArray(result);
            });
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
            return null;
        }
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        ArrayList<byte[]> values = new ArrayList<byte[]>(keys.size());
        try {
            for (List part : Lists.partition(keys, (int)10000)) {
                this.storeEnvironment.executeInReadonlyTransaction(transaction -> this.getInTransaction(part, values, transaction));
            }
            return values;
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
            return null;
        }
    }

    private void getInTransaction(List<byte[]> keys, List<byte[]> values, Transaction transaction) {
        Store store = this.storeEnvironment.openStore(this.tableName, StoreConfig.USE_EXISTING, transaction);
        for (byte[] key : keys) {
            ByteIterable result = store.get(transaction, (ByteIterable)new ArrayByteIterable(key));
            values.add(XodusStore.getByteArray(result));
        }
    }

    private static byte @Nullable [] getByteArray(ByteIterable result) {
        if (result == null) {
            return null;
        }
        return result.getBytesUnsafe();
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        XodusStore.throwIfKeyIsNull(key);
        try {
            this.storeEnvironment.executeInExclusiveTransaction(transaction -> {
                Store store = this.storeEnvironment.openStore(this.tableName, StoreConfig.USE_EXISTING, transaction);
                store.put(transaction, (ByteIterable)new ArrayByteIterable(key), (ByteIterable)new ArrayByteIterable(value));
            });
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
        }
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        try {
            this.storeEnvironment.executeInExclusiveTransaction(transaction -> {
                Store store = this.storeEnvironment.openStore(this.tableName, StoreConfig.USE_EXISTING, transaction);
                for (int i = 0; i < keysValues.size(); ++i) {
                    store.put(transaction, (ByteIterable)new ArrayByteIterable((byte[])keysValues.getFirst(i)), (ByteIterable)new ArrayByteIterable((byte[])keysValues.getSecond(i)));
                    this.flushTransactionIfNecessary(transaction, i);
                }
            });
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
        }
    }

    private void flushTransactionIfNecessary(Transaction transaction, int elementNumber) {
        if ((elementNumber + 1) % 10000 == 0 && !transaction.flush()) {
            throw new RuntimeException("Could not flush store '" + this.tableName + "' in storage system '" + this.storageSystemName + "'. This should never happen.");
        }
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        XodusStore.throwIfKeyIsNull(key);
        try {
            this.storeEnvironment.executeInExclusiveTransaction(transaction -> {
                Store store = this.storeEnvironment.openStore(this.tableName, StoreConfig.USE_EXISTING, transaction);
                store.delete(transaction, (ByteIterable)new ArrayByteIterable(key));
            });
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
        }
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        try {
            this.storeEnvironment.executeInExclusiveTransaction(transaction -> {
                Store store = this.storeEnvironment.openStore(this.tableName, StoreConfig.USE_EXISTING, transaction);
                for (int i = 0; i < keys.size(); ++i) {
                    store.delete(transaction, (ByteIterable)new ArrayByteIterable((byte[])keys.get(i)));
                    this.flushTransactionIfNecessary(transaction, i);
                }
            });
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
        }
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.scanInternal(beginKey, endKey, callback, false);
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.scanInternal(beginKey, endKey, callback, true);
    }

    private void scanInternal(byte[] beginKey, byte[] endKey, IKeyValueCallback callback, boolean skipValues) throws StorageException {
        XodusScanHelper scanHelper = new XodusScanHelper(this, beginKey, endKey, callback, skipValues);
        try {
            while (!scanHelper.isDone()) {
                this.storeEnvironment.executeInReadonlyTransaction((TransactionalExecutable)scanHelper);
            }
        }
        catch (Exception e) {
            XodusStore.handleXodusException(e);
        }
    }

    private static void handleXodusException(Exception e) throws StorageException {
        if (e instanceof TooBigLoggableException) {
            throw new StorageException("It seems the database is not configured with a sufficiently large log file size to handle the data that is put into it (e.g., huge files). To use a bigger size specify \"database.details.log-file-size-mb=1024\" in the teamscale.properties file (default is 512 MB).", e);
        }
        throw new StorageException(e);
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.lockProvider.obtainLock(this.storageSystemName + "/" + this.tableName + "/" + suffix);
    }

    private class XodusScanHelper
    implements TransactionalExecutable {
        private byte[] beginKey;
        private final byte[] endKey;
        private final IKeyValueCallback callback;
        private final boolean skipValues;
        private boolean done;
        final /* synthetic */ XodusStore this$0;

        private XodusScanHelper(XodusStore xodusStore, byte[] beginKey, byte[] endKey, IKeyValueCallback callback, boolean skipValues) {
            XodusStore xodusStore2 = xodusStore;
            Objects.requireNonNull(xodusStore2);
            this.this$0 = xodusStore2;
            this.done = false;
            this.beginKey = beginKey;
            this.endKey = endKey;
            this.callback = callback;
            this.skipValues = skipValues;
        }

        public boolean isDone() {
            return this.done;
        }

        public void execute(@NonNull Transaction transaction) {
            Store store = this.this$0.storeEnvironment.openStore(this.this$0.tableName, StoreConfig.USE_EXISTING, transaction);
            try (Cursor cursor = store.openCursor(transaction);){
                ByteIterable v = this.beginKey != null ? cursor.getSearchKeyRange((ByteIterable)new ArrayByteIterable(this.beginKey)) : cursor.getKey();
                if (v == null) {
                    this.done = true;
                    return;
                }
                this.reportEntriesFromCursor(cursor);
            }
        }

        private void reportEntriesFromCursor(Cursor cursor) {
            if (this.reportKeyValueToCallback(cursor)) {
                this.done = true;
                return;
            }
            int reportedKeys = 1;
            while (cursor.getNextNoDup()) {
                if (this.reportKeyValueToCallback(cursor)) {
                    this.done = true;
                    return;
                }
                if (++reportedKeys <= 10000) continue;
                this.updateBeginKeyAndDoneStatusAfterElementLimit(cursor);
                return;
            }
            this.done = true;
        }

        private void updateBeginKeyAndDoneStatusAfterElementLimit(Cursor cursor) {
            if (!cursor.getNextNoDup()) {
                this.done = true;
                return;
            }
            ByteIterable keyIterable = cursor.getKey();
            if (ByteIterable.EMPTY.equals((Object)keyIterable)) {
                this.done = true;
            } else {
                this.beginKey = ByteIterableBase.readIterator((ByteIterator)keyIterable.iterator(), (int)keyIterable.getLength());
            }
        }

        private boolean reportKeyValueToCallback(Cursor cursor) {
            ByteIterable keyIterable = cursor.getKey();
            if (ByteIterable.EMPTY.equals((Object)keyIterable)) {
                return false;
            }
            byte[] key = ByteIterableBase.readIterator((ByteIterator)keyIterable.iterator(), (int)keyIterable.getLength());
            if (this.endKey != null && BYTE_ARRAY_COMPARATOR.compare(this.endKey, key) <= 0) {
                return true;
            }
            byte[] value = null;
            if (!this.skipValues) {
                ByteIterable valueIterable = cursor.getValue();
                value = ByteIterableBase.readIterator((ByteIterator)valueIterable.iterator(), (int)valueIterable.getLength());
            }
            this.callback.callback(key, value);
            return false;
        }
    }
}

