/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ParsedAbapElementPath {
    private static final Pattern OBJECT_NAME_PATTERN = Pattern.compile("\\(.*\\s(.*)\\)\\.abap$");
    private static final String PATTERN_PROGRAM_CLASS_INTERFACE_ENHANCEMENT = "(?<elementpath>(?<type>PROG|CLAS|INTF|ENHO)/(?<name>[^/]+)\\.abap)";
    private static final String PATTERN_FUNCTION_GROUPS = "(?<elementpath>(?<type>FUGR)/(?<functiongroup>[^/]+)/(?<name>[^/]+)\\.abap)";
    private static final String PATTERN_CLASS_ADDITIONS = "(?<elementpath>(?<type>CLAS|INTF)/(?<classname>[^/]+)/(?<name>[^/]+)\\.abap)";
    private static final String PATTERN_DDIC = "(?<elementpath>(?<type>DOMA|DTEL|STRU|TABL|TTYP|VIEW)/(?<name>[^/]+)\\.abap_ddic)";
    private static final String PATTERN_CDS = "(?<elementpath>(?<type>BDEF|SRVD|DCLS|DDLS)/(?<name>[^/]+)\\.abap_cds)";
    private static final String PATTERN_DDLX = "(?<elementpath>(?<type>DDLX)/(?<name>[^/]+)\\.abap_ddlx)";
    private static final String UNKNOWN_TYPE_PATTERN = "(?<elementpath>(?<type>[A-Z]{4})/(?<name>[^/]+)\\.abap)";
    private static final String PATTERN_PACKAGE_PATH = "(?<packagepath>.*?/?(?<packagename>[^/]+))/";
    private static final String PATTERN_ABAPGIT_PROGRAM_CLASS_INTERFACE_ENHANCEMENT = "(?<elementpath>(?<name>[^./]+)\\.(?<type>prog|clas|intf|enho)\\.abap)";
    private static final String PATTERN_ABAPGIT_DDIC = "(?<elementpath>(?<name>[^./]+)\\.(?<type>doma|dtel|stru|tabl|ttyp|view)\\.(abap|abap_ddic))";
    private static final String PATTERN_ABAPGIT_FUNCTION_GROUPS = "(?<elementpath>(?<functiongroup>[^./]+)\\.(?<type>fugr)\\.(?<name>[^.]+)\\.abap)";
    private static final String PATTERN_ABAPGIT_CLASS_ADDITIONS = "(?<elementpath>(?<name>(?<classname>[^./]+)\\.(?<type>clas|intf)\\.[^.]+)\\.abap)";
    private static final String PATTERN_ABAPGIT_ENHANCEMENTS = "(?<elementpath>(?<name>[^./]+)\\.(?<type>enho)\\.[^.]+\\.abap)";
    private static final String PATTERN_ABAPGIT_CDS = "(?<elementpath>(?<name>[^./]+)\\.(?<type>ddls)\\.(asddls|acds))";
    private static final String PATTERN_ABAPGIT_DDLX = "(?<elementpath>(?<name>[^./]+)\\.(?<type>ddlx)\\.(asddlxs|acds))";
    private static final Pattern[] CQSE_ELEMENT_PATH_PATTERNS = new Pattern[]{Pattern.compile("(.*/|^)(?<elementpath>(?<type>PROG|CLAS|INTF|ENHO)/(?<name>[^/]+)\\.abap)"), Pattern.compile("(.*/|^)(?<elementpath>(?<type>FUGR)/(?<functiongroup>[^/]+)/(?<name>[^/]+)\\.abap)"), Pattern.compile("(.*/|^)(?<elementpath>(?<type>CLAS|INTF)/(?<classname>[^/]+)/(?<name>[^/]+)\\.abap)"), Pattern.compile("(.*/|^)(?<elementpath>(?<type>DOMA|DTEL|STRU|TABL|TTYP|VIEW)/(?<name>[^/]+)\\.abap_ddic)"), Pattern.compile("(.*/|^)(?<elementpath>(?<type>BDEF|SRVD|DCLS|DDLS)/(?<name>[^/]+)\\.abap_cds)"), Pattern.compile("(.*/|^)(?<elementpath>(?<type>DDLX)/(?<name>[^/]+)\\.abap_ddlx)")};
    private static final Pattern[] ABAPGIT_ELEMENT_PATH_PATTERNS = new Pattern[]{Pattern.compile("(.*?/|^)(?<elementpath>(?<name>[^./]+)\\.(?<type>prog|clas|intf|enho)\\.abap)"), Pattern.compile("(.*?/|^)(?<elementpath>(?<name>[^./]+)\\.(?<type>doma|dtel|stru|tabl|ttyp|view)\\.(abap|abap_ddic))"), Pattern.compile("(.*?/|^)(?<elementpath>(?<functiongroup>[^./]+)\\.(?<type>fugr)\\.(?<name>[^.]+)\\.abap)"), Pattern.compile("(.*?/|^)(?<elementpath>(?<name>(?<classname>[^./]+)\\.(?<type>clas|intf)\\.[^.]+)\\.abap)"), Pattern.compile("(.*?/|^)(?<elementpath>(?<name>[^./]+)\\.(?<type>enho)\\.[^.]+\\.abap)"), Pattern.compile("(.*?/|^)(?<elementpath>(?<name>[^./]+)\\.(?<type>ddls)\\.(asddls|acds))"), Pattern.compile("(.*?/|^)(?<elementpath>(?<name>[^./]+)\\.(?<type>ddlx)\\.(asddlxs|acds))")};
    private static final Pattern[] ALL_ELEMENT_PATH_PATTERNS = (Pattern[])CollectionUtils.concatenateArrays((Object[])CQSE_ELEMENT_PATH_PATTERNS, (Object[])ABAPGIT_ELEMENT_PATH_PATTERNS);
    private static final Pattern UNKNOWN_OBJECT_ELEMENT_PATH_PATTERN = Pattern.compile("(.*?/|^)(?<elementpath>(?<type>[A-Z]{4})/(?<name>[^/]+)\\.abap)");
    private static final Pattern[] CQSE_PACKAGE_PATH_PATTERNS = new Pattern[]{Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>PROG|CLAS|INTF|ENHO)/(?<name>[^/]+)\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>FUGR)/(?<functiongroup>[^/]+)/(?<name>[^/]+)\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>CLAS|INTF)/(?<classname>[^/]+)/(?<name>[^/]+)\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>DOMA|DTEL|STRU|TABL|TTYP|VIEW)/(?<name>[^/]+)\\.abap_ddic)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>BDEF|SRVD|DCLS|DDLS)/(?<name>[^/]+)\\.abap_cds)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>DDLX)/(?<name>[^/]+)\\.abap_ddlx)")};
    private static final Pattern[] ABAPGIT_PACKAGE_PATH_PATTERNS = new Pattern[]{Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<name>[^./]+)\\.(?<type>prog|clas|intf|enho)\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<name>[^./]+)\\.(?<type>doma|dtel|stru|tabl|ttyp|view)\\.(abap|abap_ddic))"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<functiongroup>[^./]+)\\.(?<type>fugr)\\.(?<name>[^.]+)\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<name>(?<classname>[^./]+)\\.(?<type>clas|intf)\\.[^.]+)\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<name>[^./]+)\\.(?<type>enho)\\.[^.]+\\.abap)"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<name>[^./]+)\\.(?<type>ddls)\\.(asddls|acds))"), Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<name>[^./]+)\\.(?<type>ddlx)\\.(asddlxs|acds))")};
    private static final Pattern[] ALL_PACKAGE_PATH_PATTERNS = (Pattern[])CollectionUtils.concatenateArrays((Object[])CQSE_PACKAGE_PATH_PATTERNS, (Object[])ABAPGIT_PACKAGE_PATH_PATTERNS);
    private static final Pattern UNKNOWN_OBJECT_PACKAGE_PATH_PATTERN = Pattern.compile("(?<packagepath>.*?/?(?<packagename>[^/]+))/(?<elementpath>(?<type>[A-Z]{4})/(?<name>[^/]+)\\.abap)");
    private static final Set<Pattern> ABAP_GIT_PATTERNS = CollectionUtils.unionSet(Arrays.asList(ABAPGIT_ELEMENT_PATH_PATTERNS), (Collection[])new Collection[]{Arrays.asList(ABAPGIT_PACKAGE_PATH_PATTERNS)});
    private static final String ABAP_GIT_TEST_CLASSES_EXTENSION = "TESTCLASSES";
    private static final String ABAP_GIT_LOCALS_DEF_EXTENSION = "LOCALS_DEF";
    private static final String ABAP_GIT_LOCALS_IMP_EXTENSION = "LOCALS_IMP";
    private static final String ABAP_GIT_MACROS_EXTENSION = "MACROS";
    private static final String ABAP_INCLUDE_TEST_CLASSES_EXTENSION = "CCAU";
    private static final String ABAP_INCLUDE_LOCALS_DEF_EXTENSION = "CCDEF";
    private static final String ABAP_INCLUDE_LOCALS_IMP_EXTENSION = "CCIMP";
    private static final String ABAP_INCLUDE_MACROS_EXTENSION = "CCMAC";
    private final boolean parsePackagePath;
    private UniqueAbapElementName elementName;
    private String functionGroup;
    private String packageName;
    private String elementPath;
    private String packagePath;
    private String superPackagePath;
    private String className;
    private EAbapObjectType type;

    public ParsedAbapElementPath(String path) throws ConQATException {
        this(path, true);
    }

    public ParsedAbapElementPath(String path, boolean parsePackagePath) throws ConQATException {
        this.parsePackagePath = parsePackagePath;
        this.parsePath(path);
    }

    private void parsePath(String path) throws ConQATException {
        Pattern unknownPattern;
        if (AbapUtils.isBwTransformedPath(path = FileSystemUtils.normalizeSeparators((String)path))) {
            path = ParsedAbapElementPath.revertTransformation(path);
        }
        Pattern[] patterns = ALL_PACKAGE_PATH_PATTERNS;
        if (!this.parsePackagePath) {
            patterns = ALL_ELEMENT_PATH_PATTERNS;
        }
        for (Pattern pattern : patterns) {
            if (!this.checkMatchAndParse(path, pattern)) continue;
            return;
        }
        Pattern pattern = unknownPattern = this.parsePackagePath ? UNKNOWN_OBJECT_PACKAGE_PATH_PATTERN : UNKNOWN_OBJECT_ELEMENT_PATH_PATTERN;
        if (this.checkMatchAndParse(path, unknownPattern)) {
            return;
        }
        throw new ConQATException("Path " + path + " can not be parsed as path to an ABAP element (parsePackagePath=" + this.parsePackagePath + ").");
    }

    private static String revertTransformation(String path) {
        Matcher matcher = OBJECT_NAME_PATTERN.matcher(UniformPathUtils.getElementName((String)path));
        CCSMAssert.isTrue((boolean)matcher.find(), (String)("Invalid BW path: " + path));
        return "$TMP/PROG/" + matcher.group(1) + ".abap";
    }

    private boolean checkMatchAndParse(String path, Pattern pattern) throws ConQATException {
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            boolean isAbapGitFormat = ParsedAbapElementPath.isAbapGitPattern(pattern);
            this.type = EAbapObjectType.getValue(matcher.group("type").toUpperCase());
            String name = ParsedAbapElementPath.getGroupAndConvert(matcher, "name", isAbapGitFormat);
            if (pattern.pattern().endsWith(PATTERN_ABAPGIT_CLASS_ADDITIONS)) {
                name = ParsedAbapElementPath.convertToAbapInclude(name);
            }
            this.elementName = this.type == EAbapObjectType.UNKNOWN ? new UniqueAbapElementName(name, this.type, matcher.group("type").toUpperCase()) : new UniqueAbapElementName(name, this.type);
            this.elementPath = matcher.group("elementpath");
            if (this.type == EAbapObjectType.FUGR) {
                this.functionGroup = ParsedAbapElementPath.getGroupAndConvert(matcher, "functiongroup", isAbapGitFormat);
            }
            if (pattern.pattern().endsWith(PATTERN_CLASS_ADDITIONS) || pattern.pattern().endsWith(PATTERN_ABAPGIT_CLASS_ADDITIONS)) {
                this.className = ParsedAbapElementPath.getGroupAndConvert(matcher, "classname", isAbapGitFormat);
            }
            if (this.parsePackagePath) {
                String unformattedPackageName = matcher.group("packagename");
                this.packageName = ParsedAbapElementPath.getGroupAndConvert(matcher, "packagename", isAbapGitFormat);
                this.packagePath = matcher.group("packagepath");
                this.superPackagePath = this.packagePath.substring(0, this.packagePath.length() - unformattedPackageName.length());
            }
            return true;
        }
        return false;
    }

    private static String convertToAbapInclude(String name) throws ConQATException {
        String abapGitClassAdditionSuffix = StringUtils.getLastPart((String)name.toUpperCase(), (char)'.');
        String className = StringUtils.getFirstParts((String)name, (int)1, (char)'.');
        String includeName = StringUtils.flushLeft((String)className, (int)30, (char)'=');
        return switch (abapGitClassAdditionSuffix) {
            case ABAP_GIT_TEST_CLASSES_EXTENSION -> includeName.concat(ABAP_INCLUDE_TEST_CLASSES_EXTENSION);
            case ABAP_GIT_LOCALS_DEF_EXTENSION -> includeName.concat(ABAP_INCLUDE_LOCALS_DEF_EXTENSION);
            case ABAP_GIT_LOCALS_IMP_EXTENSION -> includeName.concat(ABAP_INCLUDE_LOCALS_IMP_EXTENSION);
            case ABAP_GIT_MACROS_EXTENSION -> includeName.concat(ABAP_INCLUDE_MACROS_EXTENSION);
            default -> throw new ConQATException("Unknown suffix '" + abapGitClassAdditionSuffix + "' for class addition of abapGit element '" + name + "'.");
        };
    }

    private static String getGroupAndConvert(Matcher matcher, String group, boolean isAbapGitPattern) {
        return AbapUtils.convertFileNameToAbapName(matcher.group(group), isAbapGitPattern);
    }

    private static boolean isAbapGitPattern(Pattern pattern) {
        return ABAP_GIT_PATTERNS.contains(pattern);
    }

    public UniqueAbapElementName getElementName() {
        return this.elementName;
    }

    public String getElementPath() {
        return this.elementPath;
    }

    public EAbapObjectType getType() {
        return this.type;
    }

    public String getPackageName() {
        CCSMAssert.isTrue((boolean)this.parsePackagePath, (String)"Package name must not be accessed if package path parsing was disabled.");
        return this.packageName;
    }

    public String getPackagePath() {
        CCSMAssert.isTrue((boolean)this.parsePackagePath, (String)"Package path must not be accessed if package path parsing was disabled.");
        return this.packagePath;
    }

    public String getSuperPackagePath() {
        CCSMAssert.isTrue((boolean)this.parsePackagePath, (String)"Package path must not be accessed if package path parsing was disabled.");
        return this.superPackagePath;
    }

    public String getFunctionGroup() {
        CCSMAssert.isTrue((boolean)this.isFunctionGroup(), (String)"Function group name must be only accessed for function group elements.");
        return this.functionGroup;
    }

    public String getClassName() {
        CCSMAssert.isTrue((boolean)this.isClassOrInterface(), (String)"Class/interface name must be only called for class or interface elements.");
        if (this.className == null) {
            return this.elementName.getObjectName();
        }
        return this.className;
    }

    private String getFileEnding(boolean teamscaleFormat) {
        return switch (this.type) {
            case EAbapObjectType.DDLS -> {
                if (teamscaleFormat) {
                    yield "abap_cds";
                }
                yield "asddls";
            }
            case EAbapObjectType.DDLX -> {
                if (teamscaleFormat) {
                    yield "abap_ddlx";
                }
                yield "asddlxs";
            }
            case EAbapObjectType.DOMA, EAbapObjectType.TABL, EAbapObjectType.STRU, EAbapObjectType.DTEL, EAbapObjectType.VIEW, EAbapObjectType.TTYP -> {
                if (teamscaleFormat) {
                    yield "abap_ddic";
                }
                yield "abap";
            }
            default -> "abap";
        };
    }

    public String toString() {
        return "ParsedAbapElementPath [elementName=" + String.valueOf(this.elementName) + ", functionGroup=" + this.functionGroup + ", packageName=" + this.packageName + ", elementPath=" + this.elementPath + ", packagePath=" + this.packagePath + ", superPackagePath=" + this.superPackagePath + ", className=" + this.className + "]";
    }

    public boolean isPossibleIncludeTarget() {
        return switch (this.elementName.getObjectType()) {
            case EAbapObjectType.PROG, EAbapObjectType.FUGR -> true;
            case EAbapObjectType.CLAS, EAbapObjectType.INTF -> {
                if (this.className != null && !this.className.equals(this.elementName.getObjectName())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean isClassOrInterface() {
        EAbapObjectType objectType = this.elementName.getObjectType();
        return objectType == EAbapObjectType.CLAS || objectType == EAbapObjectType.INTF;
    }

    public boolean isFunctionGroup() {
        return this.elementName.getObjectType() == EAbapObjectType.FUGR;
    }

    public String convertToAbapGitFormat() {
        String functionGroupOrClassName = this.functionGroup;
        if (StringUtils.isEmpty((String)functionGroupOrClassName)) {
            functionGroupOrClassName = this.className;
        }
        if (StringUtils.isEmpty((String)functionGroupOrClassName)) {
            Object result = this.elementName.getObjectName() + "." + this.elementName.getObjectTypeName();
            if (this.parsePackagePath) {
                result = (this.packagePath + "/").concat(((String)result).replace("/", "#"));
            }
            return ((String)result).toLowerCase().replace('!', '#') + "." + this.getFileEnding(false);
        }
        Object result = functionGroupOrClassName + "." + this.elementName.getObjectTypeName() + "." + ParsedAbapElementPath.convertToAbapGitClassAdditionSuffix(this.elementName.getObjectName());
        result = ((String)result).replace('/', '#');
        if (this.parsePackagePath) {
            result = (this.packagePath + "/").concat((String)result);
        }
        return ((String)result).toLowerCase().replace('!', '#') + "." + this.getFileEnding(false);
    }

    private static String convertToAbapGitClassAdditionSuffix(String objectName) {
        String abapInclude;
        if (objectName.length() < 30) {
            return objectName;
        }
        return switch (abapInclude = objectName.substring(30)) {
            case ABAP_INCLUDE_TEST_CLASSES_EXTENSION -> ABAP_GIT_TEST_CLASSES_EXTENSION;
            case ABAP_INCLUDE_LOCALS_DEF_EXTENSION -> ABAP_GIT_LOCALS_DEF_EXTENSION;
            case ABAP_INCLUDE_LOCALS_IMP_EXTENSION -> ABAP_GIT_LOCALS_IMP_EXTENSION;
            case ABAP_INCLUDE_MACROS_EXTENSION -> ABAP_GIT_MACROS_EXTENSION;
            default -> objectName;
        };
    }

    private static boolean isProgramClassOrInterfaceObjectInAbapGitFormat(EAbapObjectType objectType, String packagePath) {
        return EnumSet.of(EAbapObjectType.PROG, EAbapObjectType.CLAS, EAbapObjectType.INTF).contains((Object)objectType) && packagePath.contains("#");
    }

    private String getExporterStartPathWithPackageInfo() {
        String startPath = this.elementName.getObjectTypeName() + "/";
        if (!this.parsePackagePath) {
            return startPath;
        }
        int countOfSubfoldersInPackagePath = StringUtils.countCharacter((String)this.packagePath, (char)'/') + 1;
        if (ParsedAbapElementPath.isProgramClassOrInterfaceObjectInAbapGitFormat(this.elementName.getObjectType(), this.packagePath) && countOfSubfoldersInPackagePath > 2) {
            String packagePathWithoutName = StringUtils.stripSuffix((String)this.packagePath, (String)this.packageName.toLowerCase());
            packagePathWithoutName = StringUtils.stripSuffix((String)packagePathWithoutName, (String)"/");
            return (packagePathWithoutName + "/").concat(startPath);
        }
        return (this.packagePath + "/").concat(startPath);
    }

    public String convertToTeamscaleExporterFormat() {
        String functionGroupOrClassName = this.functionGroup;
        if (StringUtils.isEmpty((String)functionGroupOrClassName)) {
            functionGroupOrClassName = this.className;
        }
        String startPath = this.getExporterStartPathWithPackageInfo();
        if (StringUtils.isEmpty((String)functionGroupOrClassName)) {
            String formattedObjectName = AbapUtils.formatAbapIdentifier(this.elementName.getObjectName());
            return (startPath + formattedObjectName).toUpperCase().replace('#', '!') + "." + this.getFileEnding(true);
        }
        functionGroupOrClassName = functionGroupOrClassName.replace('/', '!');
        return (startPath + functionGroupOrClassName + "/" + this.elementName.getObjectName().replace('/', '!')).toUpperCase().replace('#', '!') + "." + this.getFileEnding(true);
    }

    public static boolean isExporterPathFormat(String path) {
        for (Pattern pattern : CQSE_PACKAGE_PATH_PATTERNS) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }
}

