/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.distributedtask.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAttachment;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskLog;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskOrchestrationPlan;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.Timeline;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TimelineRecord;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.VssJsonCollectionWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class TaskHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TaskHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ArrayList<TaskAttachment> getPlanAttachments(UUID scopeIdentifier, String hubName, UUID planId, String type) {
        UUID locationId = UUID.fromString("eb55e5d6-2f30-4295-b5ed-38da50b1fc52");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAttachment>>(){});
    }

    public TaskAttachment createAttachment(InputStream uploadStream, UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type, String name) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, uploadStream, "application/octet-stream", "application/json");
        return super.sendRequest(httpRequest, TaskAttachment.class);
    }

    public TaskAttachment getAttachment(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type, String name) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TaskAttachment.class);
    }

    public InputStream getAttachmentContent(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type, String name) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<TaskAttachment> getAttachments(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAttachment>>(){});
    }

    public void appendTimelineRecordFeed(VssJsonCollectionWrapper<List<String>> lines, UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId) {
        UUID locationId = UUID.fromString("858983e4-19bd-4c5e-864c-507b59b58b12");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, lines, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskLog appendLogContent(InputStream uploadStream, UUID scopeIdentifier, String hubName, UUID planId, int logId) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("logId", logId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, uploadStream, "application/octet-stream", "application/json");
        return super.sendRequest(httpRequest, TaskLog.class);
    }

    public TaskLog createLog(TaskLog log, UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, log, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskLog.class);
    }

    public ArrayList<String> getLog(UUID scopeIdentifier, String hubName, UUID planId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", startLine);
        queryParameters.addIfNotNull("endLine", endLine);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<TaskLog> getLogs(UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskLog>>(){});
    }

    public TaskOrchestrationPlan getPlan(UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("5cecd946-d704-471e-a45f-3b4064fcfaba");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TaskOrchestrationPlan.class);
    }

    public ArrayList<TimelineRecord> getRecords(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, Integer changeId) {
        UUID locationId = UUID.fromString("8893bc5b-35b2-4be7-83cb-99e683551db4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", changeId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TimelineRecord>>(){});
    }

    public ArrayList<TimelineRecord> updateRecords(VssJsonCollectionWrapper<List<TimelineRecord>> records, UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId) {
        UUID locationId = UUID.fromString("8893bc5b-35b2-4be7-83cb-99e683551db4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, records, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TimelineRecord>>(){});
    }

    public Timeline createTimeline(Timeline timeline, UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, timeline, "application/json", "application/json");
        return super.sendRequest(httpRequest, Timeline.class);
    }

    public void deleteTimeline(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public Timeline getTimeline(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, Integer changeId, Boolean includeRecords) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", changeId);
        queryParameters.addIfNotNull("includeRecords", includeRecords);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Timeline.class);
    }

    public ArrayList<Timeline> getTimelines(UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Timeline>>(){});
    }
}

