/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.webapi;

import com.microsoft.alm.client.model.VssException;
import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.client.utils.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class WrappedException {
    private WrappedException innerException;
    private String message;
    private String helpLink;
    private Class<?> type;
    private String typeName;
    private String typeKey;
    private int errorCode;
    private int eventId;
    private String stackTrace;

    public WrappedException() {
    }

    public WrappedException(Throwable exception, boolean includeErrorDetail) {
        this.type = exception.getClass();
        if (exception.getCause() != null) {
            this.innerException = new WrappedException(exception.getCause(), includeErrorDetail);
        }
        this.message = exception.getMessage();
        if (includeErrorDetail) {
            this.stackTrace = exception.getStackTrace().toString();
        }
        if (exception instanceof VssException) {
            this.eventId = ((VssException)exception).getEventId();
            this.errorCode = ((VssException)exception).getErrorCode();
        }
    }

    public WrappedException getInnerException() {
        return this.innerException;
    }

    public void setInnerException(WrappedException innerException) {
        this.innerException = innerException;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public Class<?> getType() {
        if (this.type == null && !StringUtil.isNullOrEmpty(this.typeName)) {
            try {
                this.setType(Class.forName(this.typeName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
        if (type != null) {
            this.typeName = type.getName();
            this.typeKey = type.getSimpleName();
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getEventId() {
        return this.eventId;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Exception Unwrap(Map<String, Class<? extends Exception>> map) {
        Exception innerException = null;
        if (this.getInnerException() != null) {
            innerException = this.getInnerException().Unwrap(map);
        }
        Object exception = null;
        Class<Object> type = !StringUtil.isNullOrEmpty(this.getTypeKey()) && map != null && map.containsKey(this.getTypeKey()) ? map.get(this.getTypeKey()) : this.getType();
        if (type != null) {
            for (int attempt = 0; attempt < 3; ++attempt) {
                try {
                    switch (attempt) {
                        case 0: {
                            Constructor<Object> exceptionConstructor = type.getConstructor(String.class, Exception.class);
                            if (exceptionConstructor == null) break;
                            exception = (Exception)exceptionConstructor.newInstance(this.message, innerException);
                            break;
                        }
                        case 1: {
                            Constructor<Object> exceptionConstructor = type.getConstructor(String.class);
                            if (exceptionConstructor == null) break;
                            exception = (Exception)exceptionConstructor.newInstance(this.message);
                            break;
                        }
                        case 2: {
                            Constructor<Object> exceptionConstructor = type.getConstructor(new Class[0]);
                            if (exceptionConstructor == null) break;
                            exception = (Exception)exceptionConstructor.newInstance(new Object[0]);
                        }
                    }
                    if (exception == null) continue;
                    break;
                }
                catch (Exception exceptionConstructor) {
                    // empty catch block
                }
            }
        }
        if (exception instanceof VssException) {
            ((VssException)exception).setEventId(this.eventId);
            ((VssException)exception).setErrorCode(this.errorCode);
        }
        if (exception == null && !StringUtil.isNullOrEmpty(this.message)) {
            assert (false) : "Unexpected exception type: " + this.getTypeName();
            exception = new VssServiceException(this.message, innerException);
        }
        assert (exception != null) : "Server Exception cannot be resolved.";
        if (exception != null && !StringUtil.isNullOrEmpty(this.getHelpLink())) {
            try {
                Method setHelpLinkMethod = exception.getClass().getMethod("setHelpLink", String.class);
                if (setHelpLinkMethod != null) {
                    setHelpLinkMethod.invoke(exception, this.getHelpLink());
                }
            }
            catch (Exception setHelpLinkMethod) {
                // empty catch block
            }
        }
        if (exception != null && this.getStackTrace() != null && this.getStackTrace().length() > 0) {
            String[] lines = this.getStackTrace().split("\r\n");
            ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
            for (String line : lines) {
                list.add(this.parseTraceLine(line));
            }
            ((Throwable)exception).setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        }
        return exception;
    }

    private StackTraceElement parseTraceLine(String line) {
        String s = line.trim();
        if (s.startsWith("at ")) {
            String methodName;
            String declaringClass;
            String fileName;
            int lineNumber;
            int i = (s = s.substring(3)).indexOf(":line ");
            if (i < 0) {
                lineNumber = 0;
            } else {
                try {
                    lineNumber = Integer.parseInt(s.substring(i + 6));
                    s = s.substring(0, i);
                }
                catch (Exception e) {
                    lineNumber = 0;
                }
            }
            i = s.indexOf(" in ");
            if (i < 0) {
                fileName = "";
            } else {
                fileName = s.substring(i + 4);
                s = s.substring(0, i);
            }
            i = s.indexOf(40);
            if (i < 0) {
                declaringClass = s;
                methodName = "";
            } else if ((i = s.lastIndexOf(46, i)) < 0) {
                declaringClass = s;
                methodName = "";
            } else {
                declaringClass = s.substring(0, i);
                methodName = s.substring(i + 1);
            }
            return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }
        return new StackTraceElement(s, "", "", 0);
    }
}

