/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.build.exceptions.BuildException;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus;
import com.microsoft.tfs.core.clients.build.flags.DefinitionQueueStatus;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.flags.QueueStatus;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildPhaseStatus;
import com.microsoft.tfs.core.clients.build.soapextensions.Agent2008Status;
import com.microsoft.tfs.core.clients.build.soapextensions.AgentStatus;
import com.microsoft.tfs.core.clients.build.soapextensions.ControllerStatus;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.clients.build.soapextensions.QueuePriority;
import com.microsoft.tfs.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BuildEnumerationHelper {
    private static final Log log = LogFactory.getLog(BuildEnumerationHelper.class);
    private static final String ENUM_SEPERATOR = ", ";

    public static String getDisplayText(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof AgentStatus) {
            return BuildEnumerationHelper.getDisplayText((AgentStatus)value);
        }
        if (value instanceof Agent2008Status) {
            return BuildEnumerationHelper.getDisplayText((Agent2008Status)value);
        }
        if (value instanceof BuildPhaseStatus) {
            return BuildEnumerationHelper.getDisplayText((BuildPhaseStatus)value);
        }
        if (value instanceof BuildReason) {
            return BuildEnumerationHelper.getDisplayText((BuildReason)value);
        }
        if (value instanceof BuildStatus) {
            return BuildEnumerationHelper.getDisplayText((BuildStatus)value);
        }
        if (value instanceof ControllerStatus) {
            return BuildEnumerationHelper.getDisplayText((ControllerStatus)value);
        }
        if (value instanceof DefinitionQueueStatus) {
            return BuildEnumerationHelper.getDisplayText((DefinitionQueueStatus)value);
        }
        if (value instanceof DeleteOptions) {
            return BuildEnumerationHelper.getDisplayText((DeleteOptions)value);
        }
        if (value instanceof QueuePriority) {
            return BuildEnumerationHelper.getDisplayText((QueuePriority)value);
        }
        if (value instanceof QueueStatus) {
            return BuildEnumerationHelper.getDisplayText((QueueStatus)value);
        }
        if (value instanceof DefinitionTriggerType) {
            return BuildEnumerationHelper.getDisplayText((DefinitionTriggerType)value);
        }
        return value.toString();
    }

    public static String getDisplayText(AgentStatus status) {
        if (status.equals(AgentStatus.UNAVAILABLE)) {
            return Messages.getString("BuildClient.AgentStatusUnavailable");
        }
        if (status.equals(AgentStatus.AVAILABLE)) {
            return Messages.getString("BuildClient.AgentStatusAvailable");
        }
        if (status.equals(AgentStatus.OFFLINE)) {
            return Messages.getString("BuildClient.AgentStatusOffline");
        }
        return "";
    }

    public static String getDisplayText(Agent2008Status status) {
        if (status == Agent2008Status.ENABLED) {
            return Messages.getString("BuildClient.2008StatusEnabled");
        }
        if (status == Agent2008Status.DISABLED) {
            return Messages.getString("BuildClient.2008StatusDisabled");
        }
        if (status == Agent2008Status.UNREACHABLE) {
            return Messages.getString("BuildClient.2008StatusUnreachable");
        }
        if (status == Agent2008Status.INITIALIZING) {
            return Messages.getString("BuildClient.2008StatusInitializing");
        }
        return "";
    }

    public static String getDisplayText(BuildPhaseStatus status) {
        if (status.equals(BuildPhaseStatus.FAILED)) {
            return Messages.getString("BuildClient.PhaseStatusFailed");
        }
        if (status.equals(BuildPhaseStatus.SUCCEEDED)) {
            return Messages.getString("BuildClient.PhaseStatusSucceeded");
        }
        if (status.equals(BuildPhaseStatus.UNKOWN)) {
            return Messages.getString("BuildClient.PhaseStatusUnknown");
        }
        return "";
    }

    public static String getDisplayText(BuildReason reason) {
        ArrayList<String> reasonStrings = new ArrayList<String>();
        if (reason.contains(BuildReason.ALL)) {
            reasonStrings.add(Messages.getString("BuildClient.BuildReasonAll"));
        } else if (reason.contains(BuildReason.TRIGGERED)) {
            reasonStrings.add(Messages.getString("BuildClient.BuildReasonTriggeredAndManual"));
        } else if (reason.equals(BuildReason.NONE)) {
            reasonStrings.add(Messages.getString("BuildClient.BuildReasonNone"));
        } else {
            if (reason.contains(BuildReason.BATCHED_CI)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonBatchedCI"));
            }
            if (reason.contains(BuildReason.INDIVIDUAL_CI)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonIndividualCI"));
            }
            if (reason.contains(BuildReason.MANUAL)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonManual"));
            }
            if (reason.contains(BuildReason.SCHEDULE)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonScheduled"));
            }
            if (reason.contains(BuildReason.SCHEDULE_FORCED)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonScheduledForced"));
            }
            if (reason.contains(BuildReason.USER_CREATED)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonUserCreated"));
            }
            if (reason.contains(BuildReason.VALIDATE_SHELVESET)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonPrivate"));
            }
            if (reason.contains(BuildReason.CHECK_IN_SHELVESET)) {
                reasonStrings.add(Messages.getString("BuildClient.BuildReasonCheckInShelveset"));
            }
        }
        return StringUtil.join(reasonStrings.toArray(new String[reasonStrings.size()]), ENUM_SEPERATOR);
    }

    public static String getDisplayText(BuildStatus status) {
        ArrayList<String> statusStrings = new ArrayList<String>();
        if (status.contains(BuildStatus.ALL)) {
            statusStrings.add(Messages.getString("BuildClient.BuildStatusAll"));
        } else if (status.equals(BuildStatus.NONE)) {
            statusStrings.add(Messages.getString("BuildClient.BuildStatusNone"));
        } else {
            if (status.contains(BuildStatus.IN_PROGRESS)) {
                statusStrings.add(Messages.getString("BuildClient.BuildStatusInProgress"));
            }
            if (status.contains(BuildStatus.SUCCEEDED)) {
                statusStrings.add(Messages.getString("BuildClient.BuildStatusSucceeded"));
            }
            if (status.contains(BuildStatus.PARTIALLY_SUCCEEDED)) {
                statusStrings.add(Messages.getString("BuildClient.BuildStatusPartiallySucceeded"));
            }
            if (status.contains(BuildStatus.FAILED)) {
                statusStrings.add(Messages.getString("BuildClient.BuildStatusFailed"));
            }
            if (status.contains(BuildStatus.STOPPED)) {
                statusStrings.add(Messages.getString("BuildClient.BuildStatusStopped"));
            }
            if (status.contains(BuildStatus.NOT_STARTED)) {
                statusStrings.add(Messages.getString("BuildClient.BuildStatusNotStarted"));
            }
        }
        return StringUtil.join(statusStrings.toArray(new String[statusStrings.size()]), ENUM_SEPERATOR);
    }

    public static String getDisplayText(ControllerStatus status) {
        if (status.equals(ControllerStatus.UNAVAILABLE)) {
            return Messages.getString("BuildClient.ControllerStatusUnavailable");
        }
        if (status.equals(ControllerStatus.AVAILABLE)) {
            return Messages.getString("BuildClient.ControllerStatusAvailable");
        }
        if (status.equals(ControllerStatus.OFFLINE)) {
            return Messages.getString("BuildClient.ControllerStatusOffline");
        }
        return "";
    }

    public static String getDisplayText(DefinitionQueueStatus status) {
        if (status.equals(DefinitionQueueStatus.DISABLED)) {
            return Messages.getString("BuildEnumerationHelper.DefinitionQueueStatusDisabled");
        }
        if (status.equals(DefinitionQueueStatus.ENABLED)) {
            return Messages.getString("BuildEnumerationHelper.DefinitionQueueStatusEnabled");
        }
        if (status.equals(DefinitionQueueStatus.PAUSED)) {
            return Messages.getString("BuildEnumerationHelper.DefinitionQueueStatusPaused");
        }
        return "";
    }

    public static String getDisplayText(DeleteOptions options) {
        ArrayList<String> optionsStrings = new ArrayList<String>();
        if (options.contains(DeleteOptions.ALL)) {
            optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsAll"));
        } else if (options.equals(DeleteOptions.NONE)) {
            optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsNone"));
        } else {
            if (options.contains(DeleteOptions.DETAILS)) {
                optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsDetails"));
            }
            if (options.contains(DeleteOptions.DROP_LOCATION)) {
                optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsDrop"));
            }
            if (options.contains(DeleteOptions.LABEL)) {
                optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsLabel"));
            }
            if (options.contains(DeleteOptions.TEST_RESULTS)) {
                optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsTestResults"));
            }
            if (options.contains(DeleteOptions.SYMBOLS)) {
                optionsStrings.add(Messages.getString("BuildEnumerationHelper.DeleteOptionsSymbols"));
            }
        }
        return StringUtil.join(optionsStrings.toArray(new String[optionsStrings.size()]), ENUM_SEPERATOR);
    }

    public static String getDisplayText(QueuePriority priority) {
        if (priority.equals(QueuePriority.ABOVE_NORMAL)) {
            return Messages.getString("BuildEnumerationHelper.QueuePriorityAboveNormal");
        }
        if (priority.equals(QueuePriority.BELOW_NORMAL)) {
            return Messages.getString("BuildEnumerationHelper.QueuePriorityBelowNormal");
        }
        if (priority.equals(QueuePriority.HIGH)) {
            return Messages.getString("BuildEnumerationHelper.QueuePriorityHigh");
        }
        if (priority.equals(QueuePriority.LOW)) {
            return Messages.getString("BuildEnumerationHelper.QueuePriorityLow");
        }
        if (priority.equals(QueuePriority.NORMAL)) {
            return Messages.getString("BuildEnumerationHelper.QueuePriorityNormal");
        }
        return "";
    }

    public static String getDisplayText(QueueStatus status) {
        ArrayList<String> statusStrings = new ArrayList<String>();
        if (status.contains(QueueStatus.ALL)) {
            statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusAll"));
        } else if (status.equals(QueueStatus.NONE)) {
            statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusNone"));
        } else {
            if (status.contains(QueueStatus.CANCELED)) {
                statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusCanceled"));
            }
            if (status.contains(QueueStatus.COMPLETED)) {
                statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusCompleted"));
            }
            if (status.contains(QueueStatus.IN_PROGRESS)) {
                statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusInProgress"));
            }
            if (status.contains(QueueStatus.POSTPONED)) {
                statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusPostponed"));
            }
            if (status.contains(QueueStatus.QUEUED)) {
                statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusQueued"));
            }
            if (status.contains(QueueStatus.RETRY)) {
                statusStrings.add(Messages.getString("BuildEnumerationHelper.StatusRetry"));
            }
        }
        return StringUtil.join(statusStrings.toArray(new String[statusStrings.size()]), ENUM_SEPERATOR);
    }

    public static String getDisplayText(DefinitionTriggerType value) {
        ArrayList<String> triggerStrings = new ArrayList<String>();
        if (value.contains(DefinitionTriggerType.ALL)) {
            triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerAll"));
        } else if (value.equals(DefinitionTriggerType.NONE)) {
            triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerManual"));
        } else {
            if (value.contains(DefinitionTriggerType.BATCHED_CONTINUOUS_INTEGRATION)) {
                triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerBatchedCI"));
            }
            if (value.contains(DefinitionTriggerType.CONTINUOUS_INTEGRATION)) {
                triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerCI"));
            }
            if (value.contains(DefinitionTriggerType.SCHEDULE)) {
                triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerSchedule"));
            }
            if (value.contains(DefinitionTriggerType.SCHEDULE_FORCED)) {
                triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerScheduleForce"));
            }
            if (value.contains(DefinitionTriggerType.GATED_CHECKIN)) {
                triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerGated"));
            }
            if (value.contains(DefinitionTriggerType.BATCHED_GATED_CHECKIN)) {
                triggerStrings.add(Messages.getString("BuildEnumerationHelper.DefinitionTriggerBatchedGated"));
            }
        }
        return StringUtil.join(triggerStrings.toArray(new String[triggerStrings.size()]), ENUM_SEPERATOR);
    }

    public static String[] getDisplayTextValues(Class enumType) {
        ArrayList<String> displayValues = new ArrayList<String>();
        Field[] fields = enumType.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().equals(enumType) || !Modifier.isPublic(fields[i].getModifiers()) || !Modifier.isFinal(fields[i].getModifiers()) || !Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                displayValues.add(BuildEnumerationHelper.getDisplayText(fields[i].get(null)));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new BuildException(MessageFormat.format("IllegalAccessException calculating display values for {0}", enumType.getName()), e);
            }
        }
        return displayValues.toArray(new String[displayValues.size()]);
    }
}

