/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IBuildServiceHost;
import com.microsoft.tfs.core.clients.build.IBuildServiceHostQueryResult;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.clients.build.internal.utils.QueryResultHelper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._BuildServiceHost;
import ms.tfs.build.buildservice._04._BuildServiceHostQueryResult;

public class BuildServiceHostQueryResult
extends WebServiceObjectWrapper
implements IBuildServiceHostQueryResult {
    private final BuildServiceHost[] serviceHosts;
    private final BuildController[] controllers;
    private final BuildAgent[] agents;

    public BuildServiceHostQueryResult(IBuildServer buildServer, _BuildServiceHostQueryResult webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.controllers = BuildTypeConvertor.toBuildControllersArray(buildServer, this.getWebServiceObject().getControllers());
        this.agents = BuildTypeConvertor.toBuildAgentArray(this.getWebServiceObject().getAgents());
        this.serviceHosts = BuildTypeConvertor.toBuildServiceHostArray(buildServer, this.getWebServiceObject().getServiceHosts());
        _BuildAgent[] _agents = (_BuildAgent[])WrapperUtils.unwrap(_BuildAgent.class, this.agents);
        _BuildController[] _controllers = (_BuildController[])WrapperUtils.unwrap(_BuildController.class, this.controllers);
        _BuildServiceHost[] _serviceHosts = (_BuildServiceHost[])WrapperUtils.unwrap(_BuildServiceHost.class, this.serviceHosts);
        this.getWebServiceObject().setAgents(_agents);
        this.getWebServiceObject().setControllers(_controllers);
        this.getWebServiceObject().setServiceHosts(_serviceHosts);
        this.afterDeserialize(buildServer);
    }

    public BuildServiceHostQueryResult(IBuildServer buildServer, BuildAgent[] agents, BuildController[] controllers, BuildServiceHost[] serviceHosts) {
        super(new _BuildServiceHostQueryResult());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(agents, "agents");
        Check.notNull(controllers, "controllers");
        Check.notNull(serviceHosts, "serviceHosts");
        this.agents = agents;
        this.controllers = controllers;
        this.serviceHosts = serviceHosts;
        this.afterDeserialize(buildServer);
    }

    public _BuildServiceHostQueryResult getWebServiceObject() {
        return (_BuildServiceHostQueryResult)this.webServiceObject;
    }

    @Override
    public IBuildServiceHost[] getServiceHosts() {
        return this.serviceHosts;
    }

    @Override
    public IFailure[] getFailures() {
        return new IFailure[0];
    }

    private void afterDeserialize(IBuildServer buildServer) {
        QueryResultHelper.match(this.serviceHosts, this.controllers, this.agents);
    }
}

