/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.utils;

import com.microsoft.tfs.core.clients.build.internal.BuildTypeInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BasicBuildTypeParseHandler
extends DefaultHandler {
    private final BuildTypeInfo buildTypeInfo;
    private final StringBuffer contents = new StringBuffer();

    public BasicBuildTypeParseHandler(String buildTypeName) {
        this.buildTypeInfo = new BuildTypeInfo(buildTypeName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.append(new String(ch, start, length));
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.contents.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name == null || name.length() == 0) {
            return;
        }
        if ("Description".equalsIgnoreCase(name)) {
            this.buildTypeInfo.setDescription(this.contents.toString());
        } else if ("BuildMachine".equalsIgnoreCase(name)) {
            this.buildTypeInfo.setBuildMachine(this.contents.toString());
        } else if ("DropLocation".equalsIgnoreCase(name)) {
            this.buildTypeInfo.setDropLocation(this.contents.toString());
        } else if ("BuildDirectoryPath".equalsIgnoreCase(name)) {
            this.buildTypeInfo.setBuildDir(this.contents.toString());
        } else if ("ProjectFileVersion".equalsIgnoreCase(name)) {
            this.buildTypeInfo.setVersion(this.contents.toString());
        }
    }

    public BuildTypeInfo getBuildTypeInfo() {
        return this.buildTypeInfo;
    }
}

