/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.security;

import com.microsoft.tfs.core.clients.security.AccessControlEntry;
import com.microsoft.tfs.core.clients.security.AccessControlEntryDetails;
import com.microsoft.tfs.core.clients.security.internal.SecurityUtility;
import com.microsoft.tfs.core.clients.webservices.ACEExtendedInformation;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptorComparer;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import ms.ws._AccessControlList;

public class AccessControlList
extends WebServiceObjectWrapper {
    private final Map<IdentityDescriptor, AccessControlEntryDetails> accessControlEntries = new TreeMap<IdentityDescriptor, AccessControlEntryDetails>(IdentityDescriptorComparer.INSTANCE);
    private boolean includeExtendedInfoForAces = false;

    public AccessControlList() {
        this(null, false);
    }

    public AccessControlList(_AccessControlList webServiceObject) {
        super(webServiceObject);
    }

    public AccessControlList(String token, boolean inherit) {
        this(token, inherit, null);
    }

    public AccessControlList(String token, boolean inherit, AccessControlEntryDetails[] accessControlEntries) {
        super(new _AccessControlList(inherit, token));
        this.setAccessControlEntries(accessControlEntries, false);
    }

    public AccessControlList(AccessControlList existingList) {
        this(existingList.getToken(), existingList.isInheritPermissions(), existingList.getAccessControlEntries());
    }

    public _AccessControlList getWebServiceObject() {
        return (_AccessControlList)this.webServiceObject;
    }

    public boolean isInheritPermissions() {
        return this.getWebServiceObject().isInheritPermissions();
    }

    public void setInheritPermissions(boolean value) {
        this.getWebServiceObject().setInheritPermissions(value);
    }

    public String getToken() {
        return this.getWebServiceObject().getToken();
    }

    public void setToken(String token) {
        this.getWebServiceObject().setToken(token);
    }

    public AccessControlEntryDetails[] getAccessControlEntries() {
        Collection<AccessControlEntryDetails> values = this.accessControlEntries.values();
        return values.toArray(new AccessControlEntryDetails[values.size()]);
    }

    public AccessControlEntry removePermissions(IdentityDescriptor descriptor, int permissionsToRemove) {
        Check.notNull(descriptor, "descriptor");
        if (!this.accessControlEntries.containsKey(descriptor)) {
            return new AccessControlEntryDetails(descriptor, null, 0, 0, null);
        }
        AccessControlEntryDetails accessControlEntry = this.accessControlEntries.get(descriptor);
        SecurityUtility.MergePermissionsResult result = SecurityUtility.mergePermissions(accessControlEntry.getAllow(), accessControlEntry.getDeny(), 0, 0, permissionsToRemove);
        accessControlEntry.setAllow(result.updatedAllow);
        accessControlEntry.setDeny(result.updatedDeny);
        return (AccessControlEntryDetails)accessControlEntry.clone();
    }

    public boolean removeAccessControlEntry(IdentityDescriptor descriptor) {
        Check.notNull(descriptor, "descriptor");
        return this.accessControlEntries.remove(descriptor) != null;
    }

    public AccessControlEntryDetails setPermissions(IdentityDescriptor descriptor, int allow, int deny, Boolean merge) {
        Check.notNull(descriptor, "descriptor");
        return this.setAccessControlEntry(new AccessControlEntryDetails(descriptor, allow, deny), merge);
    }

    public AccessControlEntryDetails setAccessControlEntry(AccessControlEntryDetails accessControlEntry, boolean merge) {
        return this.setAccessControlEntries(new AccessControlEntryDetails[]{accessControlEntry}, merge)[0];
    }

    public AccessControlEntryDetails[] setAccessControlEntries(AccessControlEntryDetails[] accessControlEntryDetailsList, boolean merge) {
        Check.notNull(accessControlEntryDetailsList, "accessControlEntryDetailsList");
        ArrayList<AccessControlEntryDetails> changedEntries = new ArrayList<AccessControlEntryDetails>();
        for (AccessControlEntryDetails newAccessControlEntry : accessControlEntryDetailsList) {
            if (this.accessControlEntries.containsKey(newAccessControlEntry.getSerializableDescriptor())) {
                AccessControlEntryDetails existingEntry = this.accessControlEntries.get(newAccessControlEntry.getSerializableDescriptor());
                if (merge) {
                    SecurityUtility.MergePermissionsResult result = SecurityUtility.mergePermissions(existingEntry.getAllow(), existingEntry.getDeny(), newAccessControlEntry.getAllow(), newAccessControlEntry.getDeny(), 0);
                    existingEntry.setAllow(result.updatedAllow);
                    existingEntry.setDeny(result.updatedDeny);
                    newAccessControlEntry.setAllow(result.updatedAllow);
                    newAccessControlEntry.setDeny(result.updatedDeny);
                } else {
                    existingEntry.setAllow(newAccessControlEntry.getAllow() & ~newAccessControlEntry.getDeny());
                    existingEntry.setDeny(newAccessControlEntry.getDeny());
                    newAccessControlEntry.setAllow(existingEntry.getAllow());
                }
            } else {
                AccessControlEntryDetails copiedAccessControlEntry = new AccessControlEntryDetails(newAccessControlEntry.getSerializableDescriptor(), newAccessControlEntry.getAllow() & ~newAccessControlEntry.getDeny(), newAccessControlEntry.getDeny());
                ACEExtendedInformation extendedInformation = newAccessControlEntry.getExtendedInformation();
                if (extendedInformation != null) {
                    copiedAccessControlEntry.setExtendedInformation(extendedInformation);
                }
                this.accessControlEntries.put(newAccessControlEntry.getSerializableDescriptor(), copiedAccessControlEntry);
                newAccessControlEntry.setAllow(copiedAccessControlEntry.getAllow());
            }
            changedEntries.add(newAccessControlEntry);
        }
        return changedEntries.toArray(new AccessControlEntryDetails[changedEntries.size()]);
    }

    public AccessControlEntryDetails queryAccessControlEntry(IdentityDescriptor descriptor) {
        Check.notNull(descriptor, "descriptor");
        return this.queryAccessControlEntries(new IdentityDescriptor[]{descriptor})[0];
    }

    public AccessControlEntryDetails[] queryAccessControlEntries(IdentityDescriptor[] descriptors) {
        ArrayList<AccessControlEntryDetails> accessControlEntryList = new ArrayList<AccessControlEntryDetails>();
        if (descriptors == null) {
            ArrayList<IdentityDescriptor> allDescriptors = new ArrayList<IdentityDescriptor>();
            for (AccessControlEntryDetails entry : this.accessControlEntries.values()) {
                allDescriptors.add(entry.getSerializableDescriptor());
            }
            descriptors = allDescriptors.toArray(new IdentityDescriptor[allDescriptors.size()]);
        }
        for (IdentityDescriptor descriptor : descriptors) {
            AccessControlEntryDetails returnableAccessControlEntry;
            if (this.accessControlEntries.containsKey(descriptor)) {
                AccessControlEntryDetails storedAccessControlEntry = this.accessControlEntries.get(descriptor);
                returnableAccessControlEntry = (AccessControlEntryDetails)storedAccessControlEntry.clone();
            } else {
                ACEExtendedInformation extendedInfo = this.includeExtendedInfoForAces ? new ACEExtendedInformation(0, 0, 0, 0) : null;
                returnableAccessControlEntry = new AccessControlEntryDetails(descriptor, null, 0, 0, extendedInfo);
            }
            accessControlEntryList.add(returnableAccessControlEntry);
        }
        return accessControlEntryList.toArray(new AccessControlEntryDetails[accessControlEntryList.size()]);
    }

    public void loadAce(AccessControlEntryDetails ace) {
        this.accessControlEntries.put(ace.getSerializableDescriptor(), ace);
    }

    public boolean isIncludeExtendedInfoForAces() {
        return this.includeExtendedInfoForAces;
    }

    public void setIncludeExtendedInfoForAces(boolean value) {
        this.includeExtendedInfoForAces = value;
    }
}

