/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;

public final class GetStatus {
    private int numOperations;
    private int numConflicts;
    private int numUpdated;
    private int numWarnings;
    private int numResolvedConflicts;
    private final List<Failure> failures = new ArrayList<Failure>();
    private boolean haveResolvableWarnings;
    private boolean canceled = false;

    public void combine(GetStatus getStatus) {
        this.numOperations += getStatus.numOperations;
        this.numConflicts += getStatus.numConflicts;
        this.numUpdated += getStatus.numUpdated;
        this.numWarnings += getStatus.numWarnings;
        this.numResolvedConflicts += getStatus.numResolvedConflicts;
        this.haveResolvableWarnings |= getStatus.haveResolvableWarnings;
        this.failures.addAll(getStatus.failures);
    }

    public Failure[] getFailures() {
        return this.failures.toArray(new Failure[this.failures.size()]);
    }

    public void addFailure(Failure failure) {
        Check.notNull(failure, "failure");
        this.failures.add(failure);
    }

    public int getNumFailures() {
        return this.failures.size();
    }

    public int getNumOperations() {
        return this.numOperations;
    }

    public void setNumOperations(int value) {
        this.numOperations = value;
    }

    public void decrementNumOperations() {
        --this.numOperations;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    public void incrementNumConflicts() {
        ++this.numConflicts;
    }

    public void setNumConflicts(int value) {
        this.numConflicts = value;
    }

    public int getNumUpdated() {
        return this.numUpdated;
    }

    public void incrementNumUpdated() {
        ++this.numUpdated;
    }

    public int getNumWarnings() {
        return this.numWarnings;
    }

    public void incrementNumWarnings() {
        ++this.numWarnings;
    }

    public int getNumResolvedConflicts() {
        return this.numResolvedConflicts;
    }

    public void setNumResolvedConflicts(int numResolvedConflicts) {
        this.numResolvedConflicts = numResolvedConflicts;
    }

    public void incrementNumResolvedConflicts() {
        ++this.numResolvedConflicts;
    }

    public boolean isNoActionNeeded() {
        return this.getNumOperations() == 0 && this.getNumConflicts() == 0 && this.getNumWarnings() == 0 && this.getNumFailures() == 0 && this.getNumResolvedConflicts() == 0;
    }

    public boolean haveResolvableWarnings() {
        return this.haveResolvableWarnings;
    }

    public void setHaveResolvableWarnings(boolean value) {
        this.haveResolvableWarnings = value;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

