/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;

public class UndoneChange {
    private final LocalPendingChange pendingChange;
    private final ChangeType undoneChangeType;
    private String revertToServerItem;

    public UndoneChange(LocalPendingChange pcEntry, String revertToServerItem, ChangeType undoneChangeType) {
        this.pendingChange = pcEntry;
        this.revertToServerItem = revertToServerItem;
        this.undoneChangeType = undoneChangeType;
    }

    public LocalPendingChange getPendingChange() {
        return this.pendingChange;
    }

    public ChangeType getUndoneChangeType() {
        return this.undoneChangeType;
    }

    public String getRevertToServerItem() {
        return this.revertToServerItem;
    }

    public void setRevertToServerItem(String value) {
        this.revertToServerItem = value;
    }

    public boolean isUndoingAdd() {
        return this.undoneChangeType.contains(ChangeType.ADD);
    }

    public boolean isUndoingRename() {
        return this.undoneChangeType.contains(ChangeType.RENAME);
    }

    public boolean isUndoingBranch() {
        return this.undoneChangeType.contains(ChangeType.BRANCH);
    }

    public boolean isUndoingLock() {
        return this.undoneChangeType.contains(ChangeType.LOCK);
    }

    public boolean isUndoingRecursiveChange() {
        return this.undoneChangeType.containsAny(ChangeType.RENAME_OR_DELETE) && ItemType.FOLDER == this.pendingChange.getItemType();
    }

    public ChangeType getRemainingChangeType() {
        return this.pendingChange.getChangeType().remove(this.undoneChangeType);
    }
}

