/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem;

import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.category.Category;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import java.util.Arrays;

public class GroupDataProvider {
    private static final GUID GLOBAL_GROUP_DOMAIN_NAME = new GUID("488bb442-0beb-4c1e-98b6-4eddc604bd9e");
    private final WorkItemClient client;
    private final Project project;
    private String[] categoryNames;
    private String[] groupNames;

    public GroupDataProvider(WorkItemClient client, String projectName) {
        this.client = client;
        this.project = client.getProjects().get(projectName);
    }

    public String[] getGroups() {
        if (this.groupNames == null) {
            GUID projectGuid = this.project != null ? this.project.getGUID() : GUID.EMPTY;
            this.groupNames = this.client.getGlobalAndProjectGroups(GLOBAL_GROUP_DOMAIN_NAME, projectGuid);
            Arrays.sort(this.groupNames);
        }
        return this.groupNames;
    }

    public String[] getWorkItemCategories() {
        if (this.categoryNames == null) {
            ArrayList<String> names = new ArrayList<String>();
            if (this.project != null) {
                for (Category category : this.project.getCategories()) {
                    names.add(category.getName());
                }
            }
            this.categoryNames = names.toArray(new String[names.size()]);
            Arrays.sort(this.categoryNames);
        }
        return this.categoryNames;
    }
}

