/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.link;

import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.internal.link.ExternalLinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.HyperlinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RelatedLinkImpl;
import com.microsoft.tfs.core.clients.workitem.link.ExternalLink;
import com.microsoft.tfs.core.clients.workitem.link.Hyperlink;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkType;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEndCollection;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkUtils;
import com.microsoft.tfs.util.Check;

public class LinkFactory {
    private static int RELATED_LINKTYPES_ID_V2 = 0;
    private static String RELATED_LINKTYPES_REFNAME_V3 = "System.LinkTypes.Related-Forward";

    public static RelatedLink newRelatedLink(WorkItem sourceWorkItem, WorkItem targetWorkItem, String comment, boolean readOnly) {
        WorkItemClient client = sourceWorkItem.getClient();
        int linkId = RELATED_LINKTYPES_ID_V2;
        if (client.supportsWorkItemLinkTypes()) {
            WorkItemLinkTypeEndCollection ends = client.getLinkTypes().getLinkTypeEnds();
            WorkItemLinkTypeEnd related = ends.get(RELATED_LINKTYPES_REFNAME_V3);
            Check.notNull(related, "related");
            linkId = related.getID();
        }
        return LinkFactory.newRelatedLink(sourceWorkItem, targetWorkItem, linkId, comment, readOnly);
    }

    public static RelatedLink newRelatedLink(WorkItem sourceWorkItem, WorkItem targetWorkItem, int linkTypeId, String comment, boolean readOnly) {
        RelatedLinkImpl relatedLink = new RelatedLinkImpl(sourceWorkItem, targetWorkItem.getFields().getID(), linkTypeId, comment, true, readOnly);
        relatedLink.setDescription(WorkItemLinkUtils.buildDescriptionFromWorkItem(targetWorkItem));
        relatedLink.setWorkItem(targetWorkItem);
        return relatedLink;
    }

    public static Hyperlink newHyperlink(String location, String comment, boolean readOnly) {
        return new HyperlinkImpl(location, comment, -1, true, readOnly);
    }

    public static ExternalLink newExternalLink(RegisteredLinkType linkType, String artifactUri, String comment, boolean readOnly) {
        ArtifactID.checkURIIsWellFormed(artifactUri);
        return new ExternalLinkImpl(linkType, artifactUri, comment, -1, true, readOnly);
    }

    public static ExternalLink newExternalLink(RegisteredLinkType linkType, ArtifactID artifactId, String comment, boolean readOnly) {
        return new ExternalLinkImpl(linkType, artifactId.encodeURI(), comment, -1, true, readOnly);
    }
}

