/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.query.WIQDocumentParseException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import com.microsoft.tfs.util.xml.DefaultErrorHandler;
import com.microsoft.tfs.util.xml.DocumentBuilderCache;
import com.microsoft.tfs.util.xml.JAXPUtils;
import com.microsoft.tfs.util.xml.XMLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WIQDocument {
    private static final int DEFAULT_VERSION = 1;
    private static final String XML_SCHEMA_RESOURCE_NAME = "wiq.xsd";
    private static final String VERSION_ATTRIBUTE_NAME = "Version";
    private static final String WORK_ITEM_QUERY_ELEMENT_NAME = "WorkItemQuery";
    private static final String WIQL_ELEMENT_NAME = "Wiql";
    private static final String TEAM_FOUNDATION_SERVER_ELEMENT_NAME = "TeamFoundationServer";
    private static final String TEAM_PROJECT_ELEMENT_NAME = "TeamProject";
    private static final String TEAM_NAME_ELEMENT_NAME = "TeamName";
    private static final Object docBuilderCacheLock = new Object();
    private static DocumentBuilderCache docBuilderCache;
    private final String wiql;
    private final String teamFoundationServer;
    private final String teamProject;
    private final String teamName;
    private final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilderCache getDocBuilderCache() {
        Object object = docBuilderCacheLock;
        synchronized (object) {
            if (docBuilderCache != null) {
                return docBuilderCache;
            }
            DocumentBuilderFactory factory = WIQDocument.createDocumentBuilderFactory();
            docBuilderCache = new DocumentBuilderCache(factory, new DefaultErrorHandler(), null);
            return docBuilderCache;
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        InputStream schemaStream = WIQDocument.class.getResourceAsStream(XML_SCHEMA_RESOURCE_NAME);
        if (schemaStream == null) {
            throw new WIQDocumentParseException(Messages.getString("WiqDocument.UnableToLoadWiqSchema"));
        }
        try {
            byte[] schema = IOUtils.toByteArray(schemaStream);
            return JAXPUtils.newDocumentBuilderFactoryForXSValidation(factory, new ByteArrayInputStream(schema));
        }
        catch (IOException e) {
            throw new WIQDocumentParseException(e);
        }
    }

    public static WIQDocument load(File file) throws WIQDocumentParseException {
        Document document;
        Check.notNull(file, "file");
        DocumentBuilderCache cache = WIQDocument.getDocBuilderCache();
        DocumentBuilder builder = cache.takeDocumentBuilder();
        try {
            document = DOMCreateUtils.parseFile(builder, file, "UTF-8");
        }
        catch (XMLException e) {
            throw new WIQDocumentParseException(e);
        }
        finally {
            cache.releaseDocumentBuilder(builder);
        }
        return WIQDocument.load(document);
    }

    public static WIQDocument load(Document document) throws WIQDocumentParseException {
        Check.notNull(document, "document");
        Element rootElement = document.getDocumentElement();
        int version = 1;
        if (rootElement.hasAttribute(VERSION_ATTRIBUTE_NAME)) {
            try {
                version = Integer.parseInt(rootElement.getAttribute(VERSION_ATTRIBUTE_NAME));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String wiql = null;
        String teamFoundationServer = null;
        String teamProject = null;
        String teamName = null;
        Element[] rootElementChildren = DOMUtils.getChildElements(rootElement);
        for (int i = 0; i < rootElementChildren.length; ++i) {
            Element currentChild = rootElementChildren[i];
            if (WIQL_ELEMENT_NAME.equals(currentChild.getLocalName())) {
                wiql = DOMUtils.getText(currentChild).trim();
                if (wiql.trim().length() != 0) continue;
                wiql = null;
                continue;
            }
            if (TEAM_FOUNDATION_SERVER_ELEMENT_NAME.equals(currentChild.getLocalName())) {
                teamFoundationServer = DOMUtils.getText(currentChild).trim();
                if (teamFoundationServer.trim().length() != 0) continue;
                teamFoundationServer = null;
                continue;
            }
            if (TEAM_PROJECT_ELEMENT_NAME.equals(currentChild.getLocalName())) {
                teamProject = DOMUtils.getText(currentChild).trim();
                if (teamProject.trim().length() != 0) continue;
                teamProject = null;
                continue;
            }
            if (!TEAM_NAME_ELEMENT_NAME.equals(currentChild.getLocalName()) || (teamName = DOMUtils.getText(currentChild).trim()).trim().length() != 0) continue;
            teamName = null;
        }
        if (wiql == null) {
            String messageFormat = Messages.getString("WiqDocument.DocuementDidNotContainElementFormat");
            String message = MessageFormat.format(messageFormat, WIQL_ELEMENT_NAME);
            throw new WIQDocumentParseException(message);
        }
        return new WIQDocument(wiql, teamFoundationServer, teamProject, teamName, version);
    }

    public WIQDocument(String wiql, String teamFoundationServer, String teamProject, String teamName) {
        this(wiql, teamFoundationServer, teamProject, teamName, 1);
    }

    public WIQDocument(String wiql, String teamFoundationServer, String teamProject, String teamName, int version) {
        Check.notNull(wiql, "wiql");
        this.wiql = wiql;
        this.teamFoundationServer = teamFoundationServer;
        this.teamProject = teamProject;
        this.teamName = teamName;
        this.version = version;
    }

    public String getWIQL() {
        return this.wiql;
    }

    public String getTeamFoundationServer() {
        return this.teamFoundationServer;
    }

    public String getTeamProject() {
        return this.teamProject;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        String messageFormat = "wiql: [{0}] tfs: [{1}] project: [{2}] version: [{3}]";
        return MessageFormat.format("wiql: [{0}] tfs: [{1}] project: [{2}] version: [{3}]", this.wiql, this.teamFoundationServer, this.teamProject, Integer.toString(this.version));
    }

    public Document toXMLDocument() {
        Document document = DOMCreateUtils.newDocument(WORK_ITEM_QUERY_ELEMENT_NAME);
        Element root = document.getDocumentElement();
        root.setAttribute(VERSION_ATTRIBUTE_NAME, String.valueOf(this.version));
        if (this.teamFoundationServer != null) {
            String serverUrlToSave = this.teamFoundationServer;
            if (!serverUrlToSave.endsWith("/")) {
                serverUrlToSave = serverUrlToSave + "/";
            }
            DOMUtils.appendChildWithText(root, TEAM_FOUNDATION_SERVER_ELEMENT_NAME, serverUrlToSave);
        }
        if (this.teamProject != null) {
            DOMUtils.appendChildWithText(root, TEAM_PROJECT_ELEMENT_NAME, this.teamProject);
        }
        if (this.teamName != null) {
            DOMUtils.appendChildWithText(root, TEAM_NAME_ELEMENT_NAME, this.teamName);
        }
        DOMUtils.appendChildWithText(root, WIQL_ELEMENT_NAME, this.wiql);
        return document;
    }

    public void save(File file) {
        Check.notNull(file, "file");
        DOMSerializeUtils.serializeToFile(this.toXMLDocument(), file, "UTF-8", 5);
    }
}

