/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.protocol;

import com.microsoft.tfs.core.httpclient.ConnectTimeoutException;
import com.microsoft.tfs.core.httpclient.params.HttpConnectionParams;
import com.microsoft.tfs.core.httpclient.protocol.SecureProtocolSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        Socket socket = socketFactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, HttpConnectionParams params, boolean autoClose) throws IOException, UnknownHostException {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

