/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.filelock;

import com.microsoft.tfs.jni.SynchronizationUtils;
import com.microsoft.tfs.jni.filelock.ITFSFileLock;
import com.microsoft.tfs.jni.filelock.TFSFileLockException;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.util.regex.Pattern;

final class WindowsMutexFileLock
implements ITFSFileLock {
    private static final String GLOBAL_PREFIX = "Global\\";
    private final String filename;
    private final String mutexName;
    private volatile long mutexID;

    WindowsMutexFileLock(String filename) {
        Check.notNull(filename, "filename");
        this.filename = filename;
        this.mutexName = GLOBAL_PREFIX + filename.replaceAll(Pattern.quote(File.separator), "_");
        this.mutexID = SynchronizationUtils.getInstance().createMutex(this.mutexName);
        if (this.mutexID < 0L) {
            throw new TFSFileLockException("Could not create system mutex");
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void acquire() {
        if (!this.acquire(-1)) {
            throw new TFSFileLockException("Could not acquire mutex");
        }
    }

    @Override
    public boolean acquire(int timeout) {
        if (this.mutexID < 0L) {
            throw new TFSFileLockException("This file lock is closed");
        }
        int result = SynchronizationUtils.getInstance().waitForMutex(this.mutexID, timeout);
        if (result < 0) {
            throw new TFSFileLockException("Could not acquire mutex");
        }
        return result == 1;
    }

    @Override
    public void release() {
        if (this.mutexID < 0L) {
            throw new TFSFileLockException("This file lock is closed");
        }
        if (!SynchronizationUtils.getInstance().releaseMutex(this.mutexID)) {
            throw new TFSFileLockException("Could not release mutex");
        }
    }

    @Override
    public void close() {
        if (this.mutexID < 0L) {
            return;
        }
        if (!SynchronizationUtils.getInstance().closeMutex(this.mutexID)) {
            throw new TFSFileLockException("Could not close mutex");
        }
        this.mutexID = -1L;
    }
}

