/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.process;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.TypesafeEnum;
import com.microsoft.tfs.util.process.ProcessFinishedHandler;
import com.microsoft.tfs.util.process.ProcessOutputReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessRunner
implements Runnable {
    private static final Log log = LogFactory.getLog(ProcessRunner.class);
    private Process process;
    private ProcessRunnerState state;
    private final String[] commands;
    private final String[] environment;
    private final File workingDirectory;
    private final ProcessFinishedHandler finishedHandler;
    private final OutputStream capturedStandardOutput;
    private final OutputStream capturedStandardError;
    private Thread asyncThread;
    private final String commandLineForDisplay;
    private Throwable error;
    private int exitCode = -1;
    private static long threadID = 0L;

    public ProcessRunner(String[] commands, String[] environment, File workingDirectory, ProcessFinishedHandler completedHandler) {
        Check.notNull(commands, "commands");
        this.commands = commands;
        this.environment = environment;
        this.workingDirectory = workingDirectory;
        this.finishedHandler = completedHandler;
        this.capturedStandardOutput = null;
        this.capturedStandardError = null;
        this.commandLineForDisplay = this.makeCommandLineForDisplay(commands);
        this.state = ProcessRunnerState.NEW;
    }

    public ProcessRunner(String[] commands, String[] environment, File workingDirectory, ProcessFinishedHandler completedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) {
        Check.notNull(commands, "commands");
        this.commands = commands;
        this.environment = environment;
        this.workingDirectory = workingDirectory;
        this.finishedHandler = completedHandler;
        this.capturedStandardOutput = capturedStandardOutput;
        this.capturedStandardError = capturedStandardError;
        this.commandLineForDisplay = this.makeCommandLineForDisplay(commands);
        this.state = ProcessRunnerState.NEW;
    }

    public synchronized void interrupt() {
        if (this.asyncThread == null) {
            throw new IllegalStateException("This runner was not started via runAsync() so it may not be interrupted");
        }
        if (this.state == ProcessRunnerState.NEW) {
            throw new IllegalStateException("A process runner cannot be interrupted before it is started");
        }
        this.asyncThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinish() {
        ProcessRunner processRunner = this;
        synchronized (processRunner) {
            if (this.asyncThread == null) {
                throw new IllegalStateException("This runner was not started via runAsync() so you can't wait for it to finish");
            }
            if (this.isFinished()) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void runAsync(ProcessRunner runner) {
        Check.notNull(runner, "runner");
        Thread thread = new Thread(runner);
        thread.setName("Process Runner");
        runner.setThread(thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int ret;
        ProcessRunner processRunner = this;
        synchronized (processRunner) {
            if (this.state != ProcessRunnerState.NEW) {
                throw new IllegalStateException("Can only run a ProcessRunner once");
            }
        }
        if (this.commands.length == 0) {
            processRunner = this;
            synchronized (processRunner) {
                this.exitCode = 0;
                this.state = ProcessRunnerState.COMPLETED;
            }
            this.notifyTerminalState();
            return;
        }
        try {
            processRunner = this;
            synchronized (processRunner) {
                this.process = Runtime.getRuntime().exec(this.commands, this.environment, this.workingDirectory);
                this.state = ProcessRunnerState.RUNNING;
            }
        }
        catch (IOException e) {
            ProcessRunner processRunner2 = this;
            synchronized (processRunner2) {
                this.error = e;
                this.state = ProcessRunnerState.EXEC_FAILED;
            }
            this.notifyTerminalState();
            return;
        }
        Thread outputReaderThread = new Thread(new ProcessOutputReader(this.process.getInputStream(), this.capturedStandardOutput));
        String messageFormat = "Standard Output Reader {0}";
        String message = MessageFormat.format(messageFormat, Long.toString(this.getNewThreadID()));
        outputReaderThread.setName(message);
        outputReaderThread.start();
        messageFormat = "Started IO waiter thread '{0}'";
        message = MessageFormat.format(messageFormat, outputReaderThread.getName());
        log.debug((Object)message);
        Thread errorReaderThread = new Thread(new ProcessOutputReader(this.process.getErrorStream(), this.capturedStandardError));
        messageFormat = "Standard Error Reader {0}";
        message = MessageFormat.format(messageFormat, Long.toString(this.getNewThreadID()));
        errorReaderThread.setName(message);
        errorReaderThread.start();
        messageFormat = "Started IO waiter thread '{0}'";
        message = MessageFormat.format(messageFormat, errorReaderThread.getName());
        log.debug((Object)message);
        try {
            ret = this.process.waitFor();
        }
        catch (InterruptedException e) {
            log.debug((Object)"Normal interruption, interrupting all IO readers");
            this.joinReaders(new Thread[]{outputReaderThread, errorReaderThread}, true);
            ProcessRunner processRunner3 = this;
            synchronized (processRunner3) {
                this.state = ProcessRunnerState.INTERRUPTED;
            }
            this.notifyTerminalState();
            return;
        }
        if (!this.joinReaders(new Thread[]{outputReaderThread, errorReaderThread}, false)) {
            log.error((Object)"Error joining IO reader threads, setting INTERRUPTED");
            ProcessRunner e = this;
            synchronized (e) {
                this.state = ProcessRunnerState.INTERRUPTED;
            }
            this.notifyTerminalState();
            return;
        }
        try {
            this.process.getOutputStream().close();
            this.process.getInputStream().close();
            this.process.getErrorStream().close();
        }
        catch (IOException e) {
            log.error((Object)"Error closing child process's output streams after join, setting INTERRUPTED", (Throwable)e);
            ProcessRunner processRunner4 = this;
            synchronized (processRunner4) {
                this.state = ProcessRunnerState.INTERRUPTED;
            }
            this.notifyTerminalState();
            return;
        }
        ProcessRunner processRunner5 = this;
        synchronized (processRunner5) {
            this.exitCode = ret;
            this.state = ProcessRunnerState.COMPLETED;
        }
        this.notifyTerminalState();
    }

    private boolean joinReaders(Thread[] threads, boolean immediateInterrupt) {
        String message;
        String messageFormat;
        int i;
        Check.notNull(threads, "threads");
        boolean hadJoinError = false;
        if (immediateInterrupt) {
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                messageFormat = "Normal interruption of reader thread '{0}'";
                message = MessageFormat.format("Normal interruption of reader thread '{0}'", threads[i].getName());
                log.debug((Object)message);
                threads[i].interrupt();
            }
        }
        for (i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            try {
                threads[i].join();
                messageFormat = "Reader thread '{0}' joined";
                message = MessageFormat.format("Reader thread '{0}' joined", threads[i].getName());
                log.debug((Object)message);
                continue;
            }
            catch (InterruptedException e) {
                String messageFormat2 = "Error joining on reader '{0}'";
                String message2 = MessageFormat.format("Error joining on reader '{0}'", threads[i].getName());
                log.warn((Object)message2, (Throwable)e);
                hadJoinError = true;
            }
        }
        return !hadJoinError;
    }

    private synchronized long getNewThreadID() {
        return threadID++;
    }

    private String makeCommandLineForDisplay(String[] commands) {
        if (commands == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < commands.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append("\"" + commands[i] + "\"");
        }
        return sb.toString();
    }

    public String getCommandLineForDisplay() {
        return this.commandLineForDisplay;
    }

    public synchronized Throwable getExecutionError() {
        if (this.state != ProcessRunnerState.EXEC_FAILED) {
            throw new IllegalStateException("No error is available unless the process runner's state is EXEC_FAILED");
        }
        return this.error;
    }

    public synchronized int getExitCode() {
        if (this.state != ProcessRunnerState.COMPLETED) {
            throw new IllegalStateException("No exit code is available unless the process runner's state is COMPLETED");
        }
        return this.exitCode;
    }

    public synchronized ProcessRunnerState getState() {
        return this.state;
    }

    public synchronized boolean isFinished() {
        return this.state == ProcessRunnerState.COMPLETED || this.state == ProcessRunnerState.EXEC_FAILED || this.state == ProcessRunnerState.INTERRUPTED;
    }

    private synchronized void setThread(Thread thread) {
        Check.notNull(thread, "thread");
        this.asyncThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminalState() {
        if (this.finishedHandler != null) {
            if (this.state == ProcessRunnerState.COMPLETED) {
                this.finishedHandler.processCompleted(this);
            } else if (this.state == ProcessRunnerState.EXEC_FAILED) {
                this.finishedHandler.processExecFailed(this);
            } else if (this.state == ProcessRunnerState.INTERRUPTED) {
                this.finishedHandler.processInterrupted(this);
            } else {
                Check.isTrue(false, "State " + this.state.getClass().getName() + " is not a known terminal state");
            }
        }
        ProcessRunner processRunner = this;
        synchronized (processRunner) {
            this.notifyAll();
        }
    }

    public static class ProcessRunnerState
    extends TypesafeEnum {
        public static final ProcessRunnerState NEW = new ProcessRunnerState(0);
        public static final ProcessRunnerState RUNNING = new ProcessRunnerState(1);
        public static final ProcessRunnerState EXEC_FAILED = new ProcessRunnerState(2);
        public static final ProcessRunnerState INTERRUPTED = new ProcessRunnerState(3);
        public static final ProcessRunnerState COMPLETED = new ProcessRunnerState(4);

        public ProcessRunnerState(int value) {
            super(value);
        }
    }

    public static class SystemOutputOutputStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            System.out.write(b);
        }
    }

    public static class SystemErrorOutputStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            System.err.write(b);
        }
    }
}

