/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.core.user.User;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/admin/debug/force-rollback")
public class ForceRollbackService
extends ServerRenderedPageServiceBase {
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @GET
    @Hidden
    @Operation(summary="Perform rollback", description="Provides an UI to force a rollback to a given commit. This should only be used for debugging and recovery operations.", tags={"Project"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/html"})
    public String getForceRollbackPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Perform rollback", description="This service allows to force a rollback to a given commit. This should only be used for debugging and recovery operations. For manual operations, use the UI provided by the GET request.", tags={"Project"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void forceRollback(@FormParam(value="commit") UnresolvedCommitDescriptor commitDescriptor) throws StorageException {
        CommitDescriptor resolvedCommitDescriptor = this.resolve(commitDescriptor);
        ForceRollbackService.performForcedRollback(resolvedCommitDescriptor, Collections.singleton(resolvedCommitDescriptor.getBranchName()), this.getUser(), this.serviceInfo, this.criticalEventLogger);
    }

    static void performForcedRollback(CommitDescriptor commitDescriptor, Set<String> branchNames, User user, ITeamscaleServiceInfo serviceInfo, ICriticalEventLogger criticalEventLogger) throws StorageException {
        if (serviceInfo.getInternalId() == null) {
            throw new NotFoundException(String.format("Could not find a project with ID %s.", serviceInfo.getPrimaryPublicId()));
        }
        ForceRollbackService.validateCommitParameter(commitDescriptor);
        List<CommitDescriptor> commitDescriptors = branchNames.stream().map(branchName -> new CommitDescriptor(branchName, commitDescriptor.getTimestamp())).toList();
        boolean multiBranch = commitDescriptors.size() > 1;
        String reason = "Forced rollback to %s (multiBranch=%s) by user %s".formatted(commitDescriptor.getTimestamp(), multiBranch, user.getUsername());
        JobDescriptor rollbackJob = JobDescriptor.forRollback((InternalProjectId)serviceInfo.getInternalId(), (RollbackRequest)new RollbackRequest(commitDescriptors, reason), ForceRollbackTrigger.class);
        ISchedulerCommunicator.getInstance().scheduleExternalJob(serviceInfo.getIndexLayer(), rollbackJob);
        criticalEventLogger.logCriticalEventMessage((IProjectId)serviceInfo.getInternalId(), "Forced rollback event", rollbackJob.getRollbackId());
    }

    private static void validateCommitParameter(CommitDescriptor commitDescriptor) throws BadRequestException {
        long timestamp = commitDescriptor.getTimestamp();
        if (timestamp > 100000L && timestamp <= 631148400000L) {
            throw new BadRequestException("Very low timestamp for rollback given. Please ensure to enter ms since 01/01/1970 0:00");
        }
    }
}

