/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.importer.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryUtil;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/debug/abap-archive-zips")
public class DebugAbapZipDownloadService
extends ApiBase {
    private static final Pattern DATE_PATTERN = Pattern.compile("\\d{8}");
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Path(value="{sapConfigurationId}")
    @Operation(summary="Download ABAP Archive Zips", description="Downloads zip files from the given SAP connection's archive.", tags={"SAP"}, responses={@ApiResponse(responseCode="404", description="No SAP connection configuration found for given ID."), @ApiResponse(responseCode="400", description="Illegal format for date parameter. Use yyyyMMdd."), @ApiResponse(responseCode="204", description="No zip files available for the given date.")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response downloadAbapArchiveZips(@Parameter(description="Identifier of the SAP connection in the Admin perspective.", required=true) @PathParam(value="sapConfigurationId") String sapConfigurationId, @QueryParam(value="date") @Parameter(description="Date for which to return the archive zips in yyyyMMdd format. Default is today.") String date, @QueryParam(value="type") @Parameter(description="Type of zips to return. Default is all.") Set<EUpdateMode> includedExportTypes) throws StorageException, IOException {
        if (!DATE_PATTERN.matcher(date = Objects.requireNonNullElse(date, LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")))).matches()) {
            throw new BadRequestException("Date '%s' is not in yyyyMMdd format.");
        }
        if (includedExportTypes.isEmpty()) {
            includedExportTypes = EnumSet.allOf(EUpdateMode.class);
        }
        CharSequence[] requestedSuffixes = (String[])includedExportTypes.stream().map(EUpdateMode::getZipFileNameSuffix).sorted().toArray(String[]::new);
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        AbapSystemDescription abapSystemDescription = AbapSystemDescription.getInstanceFromOptionIndex((String)sapConfigurationId, (ServerOptionIndex)serverOptionIndex);
        if (abapSystemDescription == null) {
            throw new NotFoundException("No SAP connection configuration found for ID '" + sapConfigurationId + "'.");
        }
        List<java.nio.file.Path> files = DebugAbapZipDownloadService.collectFiles(sapConfigurationId, date, (String[])requestedSuffixes, serverOptionIndex);
        if (files.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)bos);){
            files.forEach(file -> {
                try {
                    zos.putArchiveEntry(new ZipArchiveEntry(file.getFileName().toString()));
                    zos.write(Files.readAllBytes(file));
                    zos.closeArchiveEntry();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            });
        }
        return ResponseUtils.getFileDownloadResponse((Object)bos.toByteArray(), (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)"abap-zip-archive-%s-%s-%s.zip".formatted(sapConfigurationId, date, String.join((CharSequence)"_", requestedSuffixes)));
    }

    private static List<java.nio.file.Path> collectFiles(String configurationId, String date, String[] requestedSuffixes, ServerOptionIndex serverOptionIndex) {
        List<java.nio.file.Path> list;
        block10: {
            CanonicalFile archiveDirectory = AbapRepositoryUtil.buildRepositoryLocation((String)configurationId, (String)"archive", (ServerOptionIndex)serverOptionIndex);
            if (!archiveDirectory.exists() || !archiveDirectory.isDirectory()) {
                throw new NotFoundException("'%s' does not exist or is not a directory.".formatted(archiveDirectory));
            }
            Stream<java.nio.file.Path> stream = Files.walk(archiveDirectory.toPath(), new FileVisitOption[0]);
            try {
                list = stream.filter(p -> DebugAbapZipDownloadService.isRelevantFile(p, date, requestedSuffixes)).toList();
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageException e) {
                    throw new NotFoundException("Failed to get archive location for configuration " + configurationId, (Throwable)e);
                }
                catch (IOException e) {
                    throw new NotFoundException("Issue while processing the zip files.", (Throwable)e);
                }
            }
            stream.close();
        }
        return list;
    }

    private static boolean isRelevantFile(java.nio.file.Path path, String date, String[] requestedSuffixes) {
        String fileName = path.getFileName().toString();
        if (!StringUtils.endsWithOneOf((String)StringUtils.stripSuffix((String)fileName, (String)".zip"), (String[])requestedSuffixes)) {
            return false;
        }
        return fileName.contains("_%s-".formatted(date));
    }
}

