/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.architecture.ArchitectureConstraintInfo;
import com.teamscale.index.architecture.DependencyPolicyInfo;
import com.teamscale.index.architecture.TypeDependencyInfo;
import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.format.ECodeMappingType;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemMappingToIdsEvaluator;
import com.teamscale.service.architecture.ArchitectureAssessmentDto;
import com.teamscale.service.architecture.ArchitectureAssessmentUtils;
import com.teamscale.wia.TeamscaleIssueId;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public class ArchitectureAssessmentDtoConverter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServicePermissions permissions;
    private final SpecItemMappingToIdsEvaluator specItemEvaluator;

    public ArchitectureAssessmentDtoConverter(ServicePermissions permissions, SpecItemMappingToIdsEvaluator specItemEvaluator) {
        this.permissions = permissions;
        this.specItemEvaluator = specItemEvaluator;
    }

    public ArchitectureAssessmentDto buildArchitectureAssessmentDto(ArchitectureDefinition architecture, ArchitectureAssessmentInfo assessmentInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, Pattern typeSearchPattern, UserIndex userIndex) throws StorageException {
        Map findingsByPath = FindingsServiceUtils.getFindingsVirtualPathAware((ProjectStorageSystem)projectStorageSystem, (HistoryAccessOption)historyAccessOption, (UniformPath)UniformPath.EType.CODE.root());
        Map matchedSpecItemIds = this.specItemEvaluator.getComponentToSpecItemIds();
        return new ArchitectureAssessmentDto(ArchitectureAssessmentDtoConverter.buildArchitectureComponentDto(architecture, assessmentInfo.getRoot(), matchedSpecItemIds, typeSearchPattern), assessmentInfo.getOrphans(), ArchitectureAssessmentDtoConverter.buildDependencyPolicies(architecture, assessmentInfo, findingsByPath), assessmentInfo.fileBased, assessmentInfo.legacyCodeMapping, assessmentInfo.structureOnly, assessmentInfo.findingCreation, (List<ArchitectureConstraintInfo>)assessmentInfo.getConstraints(), (Set<String>)assessmentInfo.getUnsupportedLanguages(), assessmentInfo.getViolationCount(), this.buildCreationModificationDto(architecture.getCreationAndModificationInfo(), userIndex), architecture.getScopeIncludePattern(), architecture.getScopeExcludePattern());
    }

    private ArchitectureAssessmentDto.ArchitectureCreationModificationDto buildCreationModificationDto(ArchitectureCreationModificationInfo creationModificationInfo, UserIndex userIndex) throws StorageException {
        return new ArchitectureAssessmentDto.ArchitectureCreationModificationDto(this.resolveUser(userIndex, creationModificationInfo.getCreatedBy()), creationModificationInfo.getCreationDate(), this.resolveUser(userIndex, creationModificationInfo.getLastModifiedBy()), creationModificationInfo.getModificationDate());
    }

    public ArchitectureAssessmentDto.ArchitectureCreationModificationDto.ArchitectureUserDto resolveUser(UserIndex userIndex, @Nullable String userName) throws StorageException {
        if (userName == null) {
            return null;
        }
        User resolvedUser = null;
        if (this.permissions.hasBasicPermission(EBasicPermissionScope.USERS, userName, EBasicPermission.VIEW)) {
            resolvedUser = userIndex.getUser(userName);
        }
        if (resolvedUser == null) {
            return new ArchitectureAssessmentDto.ArchitectureCreationModificationDto.ArchitectureUserDto(userName, null, null);
        }
        return new ArchitectureAssessmentDto.ArchitectureCreationModificationDto.ArchitectureUserDto(userName, resolvedUser.getFirstName(), resolvedUser.getLastName());
    }

    private static List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto> buildDependencyPolicies(ArchitectureDefinition architecture, ArchitectureAssessmentInfo assessmentInfo, Map<UniformPath, List<TrackedFinding>> findingsByPath) {
        ListMap<Pair<String, String>, String> findingIdsByDependency = ArchitectureAssessmentUtils.getViolationFindingsForArchitecture(architecture, findingsByPath);
        ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto> result = new ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto>();
        for (DependencyPolicyInfo policyInfo : assessmentInfo.getPolicies()) {
            List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> dependencies = ArchitectureAssessmentDtoConverter.buildTypeDependencies(architecture, (Collection<TypeDependencyInfo>)policyInfo.getDependencies(), findingIdsByDependency);
            List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> toleratedDependencies = ArchitectureAssessmentDtoConverter.buildTypeDependencies(architecture, (Collection<TypeDependencyInfo>)policyInfo.getToleratedDependencies(), findingIdsByDependency);
            result.add(new ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto(policyInfo.getFrom(), policyInfo.getTo(), (List<Point>)policyInfo.getPoints(), policyInfo.getPolicyType(), policyInfo.getAssessmentType(), dependencies, toleratedDependencies));
        }
        return result;
    }

    private static List<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> buildTypeDependencies(ArchitectureDefinition architecture, Collection<TypeDependencyInfo> dependencies, ListMap<Pair<String, String>, String> findingIdsByDependency) {
        ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto> result = new ArrayList<ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto>(dependencies.size());
        for (TypeDependencyInfo dependency : dependencies) {
            result.add(ArchitectureAssessmentDtoConverter.buildTypeDependencyDto(architecture, dependency, findingIdsByDependency));
        }
        return result;
    }

    private static ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto buildTypeDependencyDto(ArchitectureDefinition architecture, TypeDependencyInfo dependency, ListMap<Pair<String, String>, String> findingIdsByDependency) {
        List ids = (List)findingIdsByDependency.getCollection((Object)new Pair((Object)dependency.getFrom(), (Object)dependency.getTo()));
        String findingId = null;
        if (ids != null) {
            if (ids.size() != 1) {
                LOGGER.warn("Found {} findings for violation of dependency {} in architecture {}. Expected exactly one.", (Object)ids.size(), (Object)dependency, (Object)architecture.getName());
            }
            findingId = (String)ids.getFirst();
        }
        return new ArchitectureAssessmentDto.ArchitectureDependencyPolicyDto.ArchitectureTypeDependencyDto(dependency.getFrom(), dependency.getTo(), dependency.getFromPath(), dependency.getToPath(), findingId);
    }

    private static ArchitectureAssessmentDto.ArchitectureComponentDto buildArchitectureComponentDto(ArchitectureDefinition architecture, ArchitectureComponentInfo component, Map<String, List<TeamscaleIssueId>> matchedSpecItemIds, @Nullable Pattern typeSearchPattern) {
        ComponentNode componentNode = architecture.getComponentByName(component.name);
        List subComponents = CollectionUtils.map((Collection)component.getSubComponents(), subComponent -> ArchitectureAssessmentDtoConverter.buildArchitectureComponentDto(architecture, subComponent, matchedSpecItemIds, typeSearchPattern));
        return new ArchitectureAssessmentDto.ArchitectureComponentDto(component.name, component.position, component.dimension, (Map<String, String>)component.getMatchedTypes(), component.stereotype, subComponents, ArchitectureAssessmentDtoConverter.buildOverlaps(component), (List<String>)component.getRedundantIncludePatterns(), (List<Integer>)component.getNumberOfMatches(), componentNode.getSpecItemMapping(), matchedSpecItemIds.getOrDefault(component.name, Collections.emptyList()), ArchitectureAssessmentDtoConverter.getTypeSearchResults(componentNode, component, typeSearchPattern), (List<CodeMapping>)componentNode.getCodeMappings(), componentNode.getDescription());
    }

    private static ArchitectureAssessmentDto.ArchitectureComponentDto.OverlapsDto buildOverlaps(ArchitectureComponentInfo component) {
        SetMap componentOverlaps = component.getComponentOverlaps();
        return new ArchitectureAssessmentDto.ArchitectureComponentDto.OverlapsDto(componentOverlaps.getRaw(), componentOverlaps.invert().getRaw());
    }

    private static PairList<String, String> getTypeSearchResults(ComponentNode componentNode, ArchitectureComponentInfo componentInfo, @Nullable Pattern typeSearchPattern) {
        PairList result = new PairList();
        if (typeSearchPattern == null) {
            return result;
        }
        UnmodifiableMap matchedTypes = componentInfo.getMatchedTypes();
        for (String matchedType : matchedTypes.keySet()) {
            if (!typeSearchPattern.matcher(matchedType).find()) continue;
            String pattern = ArchitectureAssessmentDtoConverter.determineMatchingPattern(componentNode, matchedType);
            result.add((Object)matchedType, (Object)pattern);
        }
        return result;
    }

    private static String determineMatchingPattern(ComponentNode component, String matchedType) {
        for (CodeMapping codeMapping : component.getCodeMappings()) {
            ECodeMappingType codeMappingType = codeMapping.getType();
            String pattern = codeMapping.getPattern();
            if (codeMappingType != ECodeMappingType.INCLUDE || !matchedType.matches(pattern)) continue;
            return pattern;
        }
        CCSMAssert.fail((String)("Obtained a matched type that is not matched by any include pattern: " + matchedType + "! This should never happen!"));
        return null;
    }
}

