/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.service.architecture.ArchitectureAssessmentUtils;
import com.teamscale.service.architecture.ArchitectureOverviewInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ArchitectureOverviewHandler {
    public static List<ArchitectureOverviewInfo> getArchitectureInfos(ArchitectureAssessmentIndex architectureAssessmentIndex, Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> uploadsInProgress, BasicTokenElementIndex basicTokenElementIndex) throws StorageException {
        List existingArchitectures = architectureAssessmentIndex.getAllAssessmentUniformPaths();
        Map<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType> pendingChangeTypes = ArchitectureOverviewHandler.getPendingArchitectureChangeTypes(existingArchitectures, uploadsInProgress);
        ArrayList<ArchitectureOverviewInfo> architectureInfos = new ArrayList<ArchitectureOverviewInfo>();
        ArrayList architecturePaths = new ArrayList(CollectionUtils.unionSet((Collection)existingArchitectures, (Collection[])new Collection[]{uploadsInProgress.keySet()}));
        List architectureElements = basicTokenElementIndex.getTokenElements(architecturePaths);
        for (int i = 0; i < architecturePaths.size(); ++i) {
            ArchitectureOverviewInfo.EArchitecturePendingChangeType changeType = pendingChangeTypes.get(architecturePaths.get(i));
            ArchitectureAssessmentInfo assessment = ArchitectureAssessmentUtils.getAssessmentInfo((String)architecturePaths.get(i), architectureAssessmentIndex);
            architectureInfos.add(ArchitectureOverviewHandler.createArchitectureInfo((String)architecturePaths.get(i), (BasicTokenElementInfo)architectureElements.get(i), changeType, assessment));
        }
        return architectureInfos;
    }

    private static ArchitectureOverviewInfo createArchitectureInfo(String uniformPath, BasicTokenElementInfo architectureElement, ArchitectureOverviewInfo.EArchitecturePendingChangeType changeType, ArchitectureAssessmentInfo assessment) {
        int violations = 0;
        int orphans = 0;
        EFindingCreationType findingCreation = EFindingCreationType.NONE;
        long creationTimestamp = -1L;
        long modificationTimestamp = -1L;
        if (assessment != null) {
            orphans = assessment.orphanCount();
            violations = assessment.getViolationCount();
            findingCreation = assessment.getFindingCreation();
            ArchitectureCreationModificationInfo creationModificationInfo = assessment.getCreationModificationInfo();
            if (creationModificationInfo != null) {
                creationTimestamp = Optional.ofNullable(creationModificationInfo.getCreationDate()).orElse(creationTimestamp);
                modificationTimestamp = Optional.ofNullable(creationModificationInfo.getModificationDate()).orElse(modificationTimestamp);
            }
        }
        boolean isRepositoryArchitecture = changeType != ArchitectureOverviewInfo.EArchitecturePendingChangeType.DELETE && architectureElement != null;
        return new ArchitectureOverviewInfo(uniformPath, changeType, isRepositoryArchitecture, violations, orphans, findingCreation, creationTimestamp, modificationTimestamp);
    }

    private static Map<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType> getPendingArchitectureChangeTypes(List<String> existingArchitectures, Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> uploads) {
        HashMap<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType> pendingChangeTypes = new HashMap<String, ArchitectureOverviewInfo.EArchitecturePendingChangeType>();
        HashSet addedPaths = new HashSet(CollectionUtils.filterAndMap(uploads.entrySet(), entry -> entry.getValue() == ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType.ADD, Map.Entry::getKey));
        HashSet deletedPaths = new HashSet(CollectionUtils.filterAndMap(uploads.entrySet(), entry -> entry.getValue() == ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType.DELETE, Map.Entry::getKey));
        for (Iterator deletedPath : deletedPaths) {
            pendingChangeTypes.put((String)((Object)deletedPath), ArchitectureOverviewInfo.EArchitecturePendingChangeType.DELETE);
        }
        HashSet modifiedPaths = CollectionUtils.intersectionSet(addedPaths, (Collection[])new Collection[]{existingArchitectures});
        addedPaths.removeAll(modifiedPaths);
        for (String addedPath : addedPaths) {
            pendingChangeTypes.put(addedPath, ArchitectureOverviewInfo.EArchitecturePendingChangeType.ADD);
        }
        for (String modifiedPath : modifiedPaths) {
            pendingChangeTypes.put(modifiedPath, ArchitectureOverviewInfo.EArchitecturePendingChangeType.MODIFY);
        }
        HashSet<String> unchangedArchitectures = new HashSet<String>(existingArchitectures);
        unchangedArchitectures.removeAll(addedPaths);
        unchangedArchitectures.removeAll(modifiedPaths);
        unchangedArchitectures.removeAll(deletedPaths);
        for (String unchangedArchitecture : unchangedArchitectures) {
            pendingChangeTypes.put(unchangedArchitecture, ArchitectureOverviewInfo.EArchitecturePendingChangeType.NONE);
        }
        return pendingChangeTypes;
    }
}

