/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.benchmark;

import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.audit.benchmark.MetricBenchmarkComputation;
import com.teamscale.service.audit.benchmark.ProjectBenchmarkDownloadService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.supercsv.io.CsvListWriter;

@Path(value="api/audit/metric-benchmark.csv")
public class MetricBenchmarkCsvExportService
extends ApiBase {
    private static final String PARAM_NAME_PROJECTS = "projects";
    private static final String PARAM_DESCRIPTION_PROJECTS = "The non-anonymized projects considered for the benchmark.";
    private static final String PARAM_NAME_ANONYMIZED_PROJECTS = "anonymized-projects";
    private static final String PARAM_DESCRIPTION_ANONYMIZED_PROJECTS = "The anonymized projects considered for the benchmark.";
    private static final String PARAM_NAME_METRIC_NAME = "metric-name";
    private static final String PARAM_DESCRIPTION_METRIC_NAME = "The metric used for the benchmark.";

    @GET
    @RequiresNoPermission(description="Only projects visible to the user are returned.")
    @Operation(summary="Get a (partly anonymized) benchmark results for a specific metric", description="Returns a CSV file with all benchmark results.", tags={"Audit"})
    public Response getBenchmarkResultsAsCsv(@QueryParam(value="projects") @Parameter(description="The non-anonymized projects considered for the benchmark.") List<PublicProjectId> nonAnonymizedProjectIds, @QueryParam(value="anonymized-projects") @Parameter(description="The anonymized projects considered for the benchmark.") List<PublicProjectId> anonymizedProjectIds, @QueryParam(value="metric-name") @Parameter(description="The metric used for the benchmark.") String metricName) throws StorageException {
        MetricBenchmarkComputation computationLogic = new MetricBenchmarkComputation(this.serviceInfo, (PermissionLookup<EProjectPermission>)this.getPermissions().getProjectPermissionLookup());
        List<ProjectBenchmarkDownloadService.BenchmarkResult> benchmarkResults = computationLogic.getBenchmarkResults(metricName, nonAnonymizedProjectIds, anonymizedProjectIds);
        String entity = CsvServiceUtils.createCsvString(csvListWriter -> MetricBenchmarkCsvExportService.createCsvData(MetricBenchmarkCsvExportService.sortBenchmarkResult(benchmarkResults, metricName), csvListWriter));
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"metric-benchmark.csv");
    }

    private static void createCsvData(List<ProjectBenchmarkDownloadService.BenchmarkResult> benchmarkResults, CsvListWriter csvListWriter) throws IOException {
        for (ProjectBenchmarkDownloadService.BenchmarkResult result : benchmarkResults) {
            csvListWriter.write(MetricBenchmarkCsvExportService.toCsvColumnValues(result));
        }
    }

    protected static List<ProjectBenchmarkDownloadService.BenchmarkResult> sortBenchmarkResult(List<ProjectBenchmarkDownloadService.BenchmarkResult> benchmarkResults, String metricName) {
        Map<String, Assessment> assessmentMetricValues = Objects.requireNonNull((ProjectBenchmarkDownloadService.BenchmarkResult)CollectionUtils.getAny(benchmarkResults)).getAssessmentMetricValues();
        if (assessmentMetricValues.containsKey(metricName)) {
            benchmarkResults.sort(Comparator.comparing(benchmarkResult -> benchmarkResult.getAssessmentMetricValues().get(metricName)));
        } else {
            benchmarkResults.sort(Comparator.comparingDouble(benchmarkResult -> benchmarkResult.getDoubleMetricValues().get(metricName)));
        }
        return benchmarkResults;
    }

    protected static List<String> toCsvColumnValues(ProjectBenchmarkDownloadService.BenchmarkResult result) throws AssertionError {
        ArrayList<String> columnValues = new ArrayList<String>();
        columnValues.add(result.getProject().toString());
        CCSMAssert.isTrue((result.getDoubleMetricValues().size() + result.getAssessmentMetricValues().size() == 1 ? 1 : 0) != 0, (String)"None or more than one metric present");
        if (!result.getDoubleMetricValues().isEmpty()) {
            columnValues.add(String.valueOf(result.getDoubleMetricValues().values().iterator().next()));
        } else {
            Assessment assessment = result.getAssessmentMetricValues().values().iterator().next();
            columnValues.add(String.valueOf(assessment.getColorFrequency(ETrafficLightColor.RED)));
            columnValues.add(String.valueOf(assessment.getColorFrequency(ETrafficLightColor.YELLOW)));
            columnValues.add(String.valueOf(assessment.getColorFrequency(ETrafficLightColor.GREEN)));
        }
        return columnValues;
    }
}

