/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/analysis-profiles")
public class AnalysisProfileEditHistoryService
extends ApiBase {
    @GET
    @Path(value="history/{analysisProfileName}")
    @Operation(summary="Analysis Profile Edit History", description="Returns the different versions of an analysis profile containing a version corresponding to each time the analysis profile was edited.")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    public List<AnalysisProfileVersionedIndex.AnalysisProfileEditVersion> getAnalysisProfileEditVersionHistory(@PathParam(value="analysisProfileName") String analysisProfile) throws StorageException {
        AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory profileVersionHistory = ((AnalysisProfileVersionedIndex)this.serviceInfo.getIndexLayer().openGlobalStorageSystem().openGlobalIndex(AnalysisProfileVersionedIndex.class)).getAnalysisProfileVersionHistory(analysisProfile);
        if (profileVersionHistory == null) {
            return List.of();
        }
        return profileVersionHistory.history();
    }

    @GET
    @Path(value="history-timestamps/{analysisProfileName}")
    @Operation(summary="Analysis Profile Edit History Creation Times", description="Returns a list of timestamps, each corresponding to the creation of a new profile edit history entry.")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    public List<Long> getAnalysisProfileEditVersionHistoryTimestamps(@PathParam(value="analysisProfileName") String analysisProfile) throws StorageException {
        return this.getAnalysisProfileEditVersionHistory(analysisProfile).stream().map(AnalysisProfileVersionedIndex.AnalysisProfileEditVersion::lastEdited).toList();
    }
}

