/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.service.documentation.analysis_profile.AnalysisProfileDocumentationBuilderConfiguration;
import com.teamscale.service.documentation.analysis_profile.CodeInspectorFindingDocumentation;
import com.teamscale.service.documentation.analysis_profile.CodeInspectorGroupDocumentation;
import com.teamscale.service.documentation.analysis_profile.FindingDocumentation;
import com.teamscale.service.documentation.analysis_profile.GroupDocumentation;
import com.teamscale.service.documentation.analysis_profile.GroupDocumentationBuilderBase;
import com.teamscale.service.documentation.analysis_profile.OptionDocumentation;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

public class CodeInspectorGroupDocumentationBuilder
extends GroupDocumentationBuilderBase {
    private static final Pattern CODE_INSPECTOR_FINDING_NAME_PATTERN = Pattern.compile("(?<name>.*)\\s+\\((?<ruleId>(?<testId>.*?)\\[\\S+?\\]\\(.\\))\\)$");
    private static final Pattern NUMBER_INDEX = Pattern.compile("&\\d");
    private static final Pattern DOTS_AND_WHITESPACE = Pattern.compile("(\\.\\.\\.\\s*)*");

    public CodeInspectorGroupDocumentationBuilder(AnalysisProfileDocumentationBuilderConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected GroupDocumentation createGroupDocumentation(AnalysisGroup group, List<FindingDocumentation> findingDocumentations) {
        return new CodeInspectorGroupDocumentation(group, findingDocumentations);
    }

    @Override
    protected FindingDocumentation createFindingDoc(String readableName, String description, EAnalysisTool tool, EFindingEnablement enablement, List<OptionDocumentation> optionDocumentations) {
        String ruleId = null;
        Matcher m = CODE_INSPECTOR_FINDING_NAME_PATTERN.matcher(readableName);
        if (m.matches()) {
            readableName = m.group("name");
            if (DOTS_AND_WHITESPACE.matcher(readableName = StringUtils.replaceAll((String)readableName, (Pattern)NUMBER_INDEX, (String)"...")).matches()) {
                readableName = "";
            }
            ruleId = m.group("ruleId");
        }
        return new CodeInspectorFindingDocumentation(readableName, description, enablement, ruleId, optionDocumentations);
    }
}

