/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.metric_thresholds;

import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.service.documentation.DocumentationNodeBase;
import com.teamscale.service.documentation.layout.Layouter;
import java.util.HashMap;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ThresholdDocumentation
extends DocumentationNodeBase<ThresholdDocumentation> {
    private static HashMap<String, String> thresholdExplanations = ThresholdDocumentation.thresholdAndExplanations();
    private MetricThresholdConfiguration configuration;

    public ThresholdDocumentation(String name, MetricThresholdConfiguration configuration) {
        super(name, null);
        this.configuration = configuration;
    }

    @Override
    protected List<ThresholdDocumentation> getChildren() {
        return CollectionUtils.emptyList();
    }

    @Override
    protected void layoutPrefix(Layouter layouter) {
        layouter.appendHeading("Metric Threshold Configuration: " + layouter.escape(this.readableName), 1);
    }

    @Override
    protected void layoutStart(Layouter layouter) {
        super.layoutStart(layouter);
        layouter.appendNewParagraph();
        layouter.append("Quality indicators are assessed based on whether contained metrics meet their thresholds.");
        layouter.appendNewParagraph();
        layouter.append("Metrics are assessed using two thresholds. If not specified otherwise, a metric gets a green assessment, if it does not violate any threshold. It gets a yellow assessment, if it violates the yellow threshold, and a red assessment, once the red threshold is violated.");
        layouter.appendNewParagraph();
        List groups = this.configuration.getMetricThresholdGroups();
        for (MetricThresholdGroup group : groups) {
            layouter.appendHeading(layouter.escape("Quality Indicator: " + group.getName()), 2);
            layouter.appendNewLine();
            layouter.appendTableStart();
            layouter.appendTableHeader("Metric", "Yellow Threshold", "Red Threshold", "Explanation");
            layouter.appendTableHorizontalLine(4);
            for (MetricThreshold threshold : group.getMetricThresholdList()) {
                String name = threshold.getDisplayName();
                String yellow = ThresholdDocumentation.getThresholdString(threshold.getThresholdYellow());
                String red = ThresholdDocumentation.getThresholdString(threshold.getThresholdRed());
                String explanation = thresholdExplanations.get(threshold.getDisplayName());
                if (explanation == null) {
                    explanation = "-";
                }
                layouter.appendTableRow(name, yellow, red, explanation);
            }
            layouter.appendTableEnd();
            layouter.appendNewParagraph();
        }
    }

    private static String getThresholdString(Double threshold) {
        String thresholdString = "none";
        if (threshold != null) {
            thresholdString = threshold.toString();
        }
        return thresholdString;
    }

    private static HashMap<String, String> thresholdAndExplanations() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Build Stability", "Assesses the number of build failures.");
        map.put("Test Stability", "Assesses the number of test failures.");
        map.put("Test Coverage", "Requires test coverage to be above the specified thresholds.");
        map.put("Policy Violations", "Requires policy violations to be below the specified thresholds.");
        map.put("Cloud Readiness Findings", "Assesses the number of cloud readiness findings.");
        map.put("Critical Maintainability Findings", "Assesses the number of critical maintainability findings.");
        map.put("Maintainability Findings Density", "Requires findings density to be below the specified thresholds. Findings density is measured in number of findings per 1,000 lines of code.");
        map.put("Security Findings", "Assesses the number of security findings.");
        map.put("Clone Coverage", "Requires clone coverage to be below the specified thresholds.");
        map.put("File Size Assessment", "Requires the amount of code in very long (red) files to be below the red threshold and the amount of code in long (yellow) and very long (red) files combined to be below the yellow threshold.");
        map.put("Method Length Assessment", "Requires the amount of code in very long (red) methods to be below the red threshold and the amount of code in long (yellow) and very long (red) methods combined to be below the yellow threshold.");
        map.put("Nesting Depth Assessment", "Requires the amount of code in very deeply nested (red) methods to be below the red threshold and the amount of code in deeply nested (yellow) and very deeply nested (red) methods combined to be below the yellow threshold.");
        return map;
    }
}

