/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisDeletionIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.DeleteExternalAnalysisResultsTrigger;
import com.teamscale.index.external.result.ExternalAnalysisResultCompileCommand;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects/{project}/external-analysis")
public class ExternalAnalysisResultsService
extends ApiBase {
    @GET
    @Path(value="debug-dump-compilation-commands/{commit}/{partition}/{path}")
    @Operation(summary="Debug dump compilation commands", description="Create a debug dump for compilation commands for a given file from a given partition.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public String getCompilationCommandsDebugDump(@Parameter(description="The commit of the external upload") @PathParam(value="commit") UnresolvedCommitDescriptor commit, @Parameter(description="The partition to read from") @PathParam(value="partition") String partition, @Parameter(description="The path to read for") @PathParam(value="path") String path) throws StorageException {
        ExternalAnalysisResultIndex index = this.openProjectIndex(ExternalAnalysisResultIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        List analysisResults = index.getAnalysisResults(partition, List.of(path));
        return analysisResults.stream().flatMap(result -> result.getByType(ExternalAnalysisResultCompileCommand.class).stream()).map(ExternalAnalysisResultCompileCommand::getData).map(Object::toString).collect(Collectors.joining("\n"));
    }

    @DELETE
    @Path(value="commits/{commit}")
    @Operation(summary="Delete single upload", description="Allows to delete a single external analysis upload.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void deleteSingleUpload(@Parameter(description="The commit of the external upload") @PathParam(value="commit") UnresolvedCommitDescriptor commit) throws StorageException {
        this.deleteCommits(List.of(this.resolve(commit)));
    }

    @DELETE
    @Path(value="partitions/{partition}")
    @Operation(summary="Delete upload partition", description="Allows to delete all external analysis uploads of a partition.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void deleteUploadPartition(@Parameter(description="The partition that should be deleted") @PathParam(value="partition") String partition) throws StorageException {
        this.deleteCommits(this.getCommits(Set.of(partition), Collections.emptySet(), null, null));
    }

    @DELETE
    @Path(value="commits")
    @Operation(summary="Delete multiple upload partitions", description="Allows to delete external analysis uploads of multiple partitions based on branches and timestamps. Deletes all uploads if partitions, branches and timestamps are not set.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void deleteMultipleUploads(@Parameter(description="The partitions that should be deleted. If not set, commits are deleted from all partitions.") @QueryParam(value="partition") Set<String> partitions, @Parameter(description="The branches where external analysis uploads should be deleted. If not set, commits are deleted from all branches.") @QueryParam(value="branch") Set<String> branches, @Parameter(description="The timestamp after external analysis uploads should be deleted (inclusive). If not set, the oldest entries are deleted, otherwise the entries that are between start and end are deleted.") @QueryParam(value="start") Long startTimestamp, @Parameter(description="The timestamp before external analysis uploads should be deleted (inclusive). If not set, the newest entries are deleted, otherwise the entries that are between start and end are deleted") @QueryParam(value="end") Long endTimestamp) throws StorageException {
        this.deleteCommits(this.getCommits(partitions, branches, startTimestamp, endTimestamp));
    }

    private Set<CommitDescriptor> getCommits(Set<String> partitions, Set<String> branches, Long startTimestamp, Long endTimestamp) throws StorageException {
        Predicate<CommitDescriptor> commitFilter = ExternalAnalysisResultsService.composeCommitFilter(branches, startTimestamp, endTimestamp);
        Predicate<ExternalAnalysisCommitInfo> commitInfoFilter = commitInfo -> commitFilter.test(commitInfo.getCommit());
        if (!partitions.isEmpty()) {
            commitInfoFilter = commitInfoFilter.and(commitInfo -> partitions.contains(commitInfo.getPartition()));
        }
        List<CommitDescriptor> commitsByAnalysisResult = this.getMatchingCommitsByAnalysisResult(commitInfoFilter);
        List<CommitDescriptor> commitsByAnalysisStatus = this.getMatchingCommitsByAnalysisStatus(partitions, commitFilter);
        return CollectionUtils.unionSet(commitsByAnalysisResult, (Collection[])new Collection[]{commitsByAnalysisStatus});
    }

    private static Predicate<CommitDescriptor> composeCommitFilter(Set<String> branches, Long startTimestamp, Long endTimestamp) {
        Predicate<CommitDescriptor> commitFilter = commit -> true;
        if (!branches.isEmpty()) {
            commitFilter = commitFilter.and(commit -> commit.isOnAnyBranch((Collection)branches));
        }
        if (startTimestamp != null) {
            commitFilter = commitFilter.and(commit -> startTimestamp <= commit.getTimestamp());
        }
        if (endTimestamp != null) {
            commitFilter = commitFilter.and(commit -> commit.getTimestamp() <= endTimestamp);
        }
        return commitFilter;
    }

    private List<CommitDescriptor> getMatchingCommitsByAnalysisResult(Predicate<ExternalAnalysisCommitInfo> filter) throws StorageException {
        List commitInfos = ExternalAnalysisResultIndex.loadCommitInfos((IBranchingLayer)this.getProjectStorageSystem().openBranchingLayer(ExternalAnalysisResultIndex.class));
        return CollectionUtils.filterAndMap((Collection)commitInfos, filter, CommitAssociatedObjectBase::getCommit);
    }

    private List<CommitDescriptor> getMatchingCommitsByAnalysisStatus(Set<String> partitions, Predicate<CommitDescriptor> commitFilter) throws StorageException {
        return (List)((ExternalAnalysisStatusIndex)this.getProjectStorageSystem().openProjectIndex(ExternalAnalysisStatusIndex.class, null)).computeWithLock(lockedIndex -> ExternalAnalysisResultsService.computeMatchingCommits(lockedIndex, partitions, commitFilter));
    }

    private static @NonNull List<CommitDescriptor> computeMatchingCommits(ExternalAnalysisStatusIndex.LockedIndexAccess lockedIndexAccess, Set<String> partitions, Predicate<CommitDescriptor> commitFilter) throws StorageException {
        if (partitions.isEmpty()) {
            partitions = CollectionUtils.mapToSet((Collection)lockedIndexAccess.getPartitionInfos(), ExternalAnalysisPartitionInfo::getName);
        }
        ArrayList<CommitDescriptor> matchingCommits = new ArrayList<CommitDescriptor>();
        for (String partition : partitions) {
            List commits = lockedIndexAccess.getCommitsForPartition(partition).extractFirstList();
            matchingCommits.addAll(CollectionUtils.filter((Collection)commits, commitFilter));
        }
        return matchingCommits;
    }

    private void deleteCommits(Collection<CommitDescriptor> commits) throws StorageException {
        ExternalAnalysisDeletionIndex externalAnalysisDeletionIndex = this.openProjectIndex(ExternalAnalysisDeletionIndex.class, null);
        for (CommitDescriptor commit : commits) {
            externalAnalysisDeletionIndex.addCommit(commit);
        }
        JobDescriptor deleteJob = JobDescriptor.forProject((InternalProjectId)this.serviceInfo.getInternalId()).withPrivilegedTrigger(DeleteExternalAnalysisResultsTrigger.class).withSchedulingReason("External data deletion triggered by user.").build();
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), deleteJob);
    }
}

