/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.external.input.ReviewFindingServiceQueryOptions;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public abstract class ReviewFindingServiceBase<S extends ReviewFindingServiceQueryOptions>
extends SessionBasedExternalAnalysisServiceBase<S> {
    private TrackedFinding getExistingFinding(ReviewFindingServiceQueryOptions parameters) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(parameters.getCommit());
        TrackedFindingsByIdIndex trackedFindingsByIdIndex = this.openProjectIndex(TrackedFindingsByIdIndex.class, historyOption);
        TrackedFinding trackedFinding = trackedFindingsByIdIndex.getFinding(parameters.getFindingId());
        if (trackedFinding == null) {
            throw new NotFoundException("No such finding: " + parameters.getFindingId());
        }
        return trackedFinding;
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> externalAnalysisResults, S parameters) throws StorageException {
        TrackedFinding trackedFinding = this.getExistingFinding((ReviewFindingServiceQueryOptions)parameters);
        ExternalAnalysisImportInfos infos = new ExternalAnalysisImportInfos();
        infos.addInfo((ExternalAnalysisImportInfo)this.createAnalysisImportInfoFindings(trackedFinding, parameters));
        sessionManager.storeNewImportInfosForSession(session, infos);
    }

    protected abstract ExternalAnalysisImportInfoFindings createAnalysisImportInfoFindings(TrackedFinding var1, S var2);
}

