/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.DelayedExternalUploadIntegrationTrigger;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.LateExternalUploadScheduleOption;
import com.teamscale.index.external.input.IntegrateImportedAnalysisResultsTrigger;
import com.teamscale.index.external.input.UploadRejectedException;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.external.input.external_storage.StoreAnalysisResultsInExternalStorageTrigger;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.external.status.ExternalAnalysisStatusLogManager;
import com.teamscale.service.upload.base.ExternalUploadServiceBase;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class SessionBasedExternalAnalysisServiceBase<S extends SessionBasedExternalAnalysisServiceQueryOptions>
extends ExternalUploadServiceBase<S> {
    public static final String SESSION_PARAMETER_NAME = "session";
    public static final String AUTO_CREATE_SESSION_PARAMETER = "auto-create";
    public static final String SESSION_ID_NOT_FOUND_ERROR = "No session with provided id found.";
    public static final String SESSION_DOES_NOT_EXIST_ERROR = "Session has been committed or deleted.";
    public static final String MODIFIED_UPLOAD_MESSAGE_ERROR = "Provided upload message is different from the one used to create the session.";
    public static final String MODIFIED_PARTITION_NAME_ERROR = "Provided partition name is different from the one used to create the session.";
    public static final String NO_PARTITION_NAME_PROVIDED_ERROR = "Partition name not provided.";
    public static final String NO_SESSION_FOUND_EXCEPTION_MESSAGE_PREFIX = "No session with ID";
    private static final String DATA_UPLOADED_SCHEDULING_REASON = "External analysis data was uploaded.";
    protected ExternalAnalysisStatusLogManager logManager = new ExternalAnalysisStatusLogManager();

    @Override
    protected IStore openExternalResultRawStore() throws StorageException {
        return this.openStoreInProject("external-analysis-results", ExternalAnalysisResultIndex.class);
    }

    protected final ExternalAnalysisSessionInfo process(EHttpMethod method, List<IExternalUploadRequestPart> requestBodyParts, S parameters, String sessionId) throws StorageException {
        Preconditions.checkArgument((sessionId != null ? 1 : 0) != 0, (Object)"Session ID must be part of URL or set to auto-create");
        this.logManager.logUploadStepInitiation(this.getClass(), this.getUser());
        this.logManager.logSessionId(sessionId);
        this.logManager.logParameters(method, (SessionBasedExternalAnalysisServiceQueryOptions)parameters);
        ExternalAnalysisStatusIndex statusIndex = this.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisImportSessionManager sessionManager = this.createSessionManager();
        ExternalAnalysisSessionInfo session = this.getOrCreateSession(parameters, sessionId, sessionManager);
        SessionBasedExternalAnalysisServiceBase.checkParameters(session, parameters);
        try {
            this.processRequest(session, sessionManager, requestBodyParts, parameters);
            if (sessionId.equals(AUTO_CREATE_SESSION_PARAMETER)) {
                this.commitSession(sessionManager, session.getSessionId(), session.getRevision().orElse(null), session.getCommit(), session.getTargetStorage().isPresent());
            }
            this.logManager.logSuccess();
            this.storeStatus(statusIndex, session, true);
        }
        catch (WebApplicationException | StorageException e) {
            this.logManager.logError(e);
            SessionBasedExternalAnalysisServiceBase.deleteSession(session.getSessionId(), sessionManager);
            this.storeStatus(statusIndex, null, false);
            throw e;
        }
        return session;
    }

    protected ExternalAnalysisImportSessionManager createSessionManager() throws StorageException {
        SessionBasedExternalAnalysisServiceBase sessionBasedExternalAnalysisServiceBase = this;
        return new ExternalAnalysisImportSessionManager(this.getIndexLayer(), this.getInternalProjectId(), x$0 -> sessionBasedExternalAnalysisServiceBase.shouldRejectUpload((CommitDescriptor)x$0));
    }

    protected abstract void processRequest(ExternalAnalysisSessionInfo var1, ExternalAnalysisImportSessionManager var2, List<IExternalUploadRequestPart> var3, S var4) throws StorageException;

    private @NonNull ExternalAnalysisSessionInfo getOrCreateSession(S parameters, String sessionId, ExternalAnalysisImportSessionManager sessionManager) throws StorageException, BadRequestException {
        if (sessionId.equals(AUTO_CREATE_SESSION_PARAMETER)) {
            this.requirePartition(parameters);
            return this.createNewSession(sessionManager, parameters);
        }
        return this.getOpenSession(sessionId, sessionManager);
    }

    protected ExternalAnalysisSessionInfo createNewSession(ExternalAnalysisImportSessionManager sessionManager, S parameters) throws BadRequestException, StorageException {
        Optional targetStorage = ExternalStorageLookup.getStorageBackend((ProjectConfiguration)this.getProjectConfiguration(), (ExternalStorageBackendIndex)this.openGlobalIndex(ExternalStorageBackendIndex.class));
        try {
            ExternalAnalysisSessionInfo session = sessionManager.createSession(new ExternalAnalysisImportSessionManager.SessionCreationParameters((ExternalStorageBackend)targetStorage.orElse(null), ((SessionBasedExternalAnalysisServiceQueryOptions)parameters).getPartition(), ((SessionBasedExternalAnalysisServiceQueryOptions)parameters).getUploadMessage(), ((ExternalUploadServiceQueryOptions)parameters).getRepository(), this.getUser().getUsername(), ((ExternalUploadServiceQueryOptions)parameters).getCommit(), ((ExternalUploadServiceQueryOptions)parameters).getRevision()));
            this.logManager.logSessionCreation(session.getSessionId());
            return session;
        }
        catch (UploadRejectedException e) {
            throw this.getUploadRejectedException(e.getRejectedCommit());
        }
    }

    private @NonNull ProjectConfiguration getProjectConfiguration() throws StorageException {
        return (ProjectConfiguration)ObjectUtils.requireNonNullElseThrow((Object)ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer()), () -> new NotFoundException("Project configuration with ID '%s (%s)' not found.".formatted(this.serviceInfo.getPrimaryPublicId(), this.serviceInfo.getInternalId())));
    }

    private ExternalAnalysisSessionInfo getOpenSession(String sessionId, ExternalAnalysisImportSessionManager sessionManager) throws StorageException {
        ExternalAnalysisSessionInfo session = (ExternalAnalysisSessionInfo)sessionManager.getSessionInfo(sessionId).orElseThrow(() -> new NotFoundException("%s %s found!".formatted(NO_SESSION_FOUND_EXCEPTION_MESSAGE_PREFIX, sessionId)));
        this.logManager.logSessionFetch(session.getSessionId());
        if (!session.isOpen()) {
            throw new BadRequestException("Session " + sessionId + " has been committed or deleted!");
        }
        return session;
    }

    protected ExternalAnalysisSessionInfo commitSession(String sessionId, ExternalAnalysisImportSessionManager sessionManager) throws NotFoundException, StorageException {
        ExternalAnalysisSessionInfo session = this.getOpenSession(sessionId, sessionManager);
        this.commitSession(sessionManager, session.getSessionId(), session.getRevision().orElse(null), session.getCommit(), session.getTargetStorage().isPresent());
        return (ExternalAnalysisSessionInfo)sessionManager.getSessionInfo(sessionId).orElseThrow(() -> new IllegalStateException("Session should exist as we just committed it."));
    }

    private void commitSession(ExternalAnalysisImportSessionManager sessionManager, String sessionId, @Nullable String revision, CommitDescriptor commit, boolean targetsExternalStorage) throws StorageException {
        this.logManager.logSessionCommit(sessionId);
        sessionManager.commitSession(sessionId);
        if (this.isLateUploadScheduleOptionConfigured() && this.isLateUpload(commit, revision)) {
            LOGGER.warn("Delaying late external upload: {}", (Object)sessionId);
        } else if (sessionManager.markSessionAsScheduled(sessionId)) {
            this.scheduleJob(commit, targetsExternalStorage);
        }
    }

    protected static ExternalAnalysisSessionInfo deleteSession(String sessionId, ExternalAnalysisImportSessionManager sessionManager) throws StorageException, NotFoundException {
        ExternalAnalysisSessionInfo sessionInfo = (ExternalAnalysisSessionInfo)sessionManager.getSessionInfo(sessionId).orElseThrow(() -> new NotFoundException("Session with ID '" + sessionId + "' does not exist."));
        sessionManager.deleteSession(sessionId);
        return sessionInfo;
    }

    private boolean isLateUpload(CommitDescriptor commit, @Nullable String revision) throws StorageException {
        ServerOptionIndex serverOptionIndex;
        int ageThresholdMinutes;
        RepositoryLogIndex repositoryLogIndex;
        long latestCommitTimestamp;
        boolean isLateUpload;
        long timestamp = commit.getTimestamp();
        boolean bl = isLateUpload = timestamp < (latestCommitTimestamp = (repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null)).getNewestTimestamp()) - Duration.ofMinutes(ageThresholdMinutes = LateExternalUploadScheduleOption.getAgeThreshold((ServerOptionIndex)(serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class)))).toMillis();
        if (isLateUpload) {
            LOGGER.warn("Marking upload as late: {}. Session timestamp is {} ({}), while newest processed commit timestamp is {} ({}), which exceeds the threshold of {} minute(s).", (Object)revision, (Object)timestamp, (Object)DateTimeUtils.getUiFormattedDateString((long)timestamp), (Object)latestCommitTimestamp, (Object)DateTimeUtils.getUiFormattedDateString((long)latestCommitTimestamp), (Object)ageThresholdMinutes);
            if (latestCommitTimestamp > Instant.now().toEpochMilli()) {
                LOGGER.error("It seems that the latest commit timestamp is in the future. This can happen when integrating external data with future timestamps. Teamscale will hold off processing further uploads until they are within the \"late external upload\" age threshold of this upload again. Please check if this was intentional, or remove the future upload otherwise.");
            }
        }
        return isLateUpload;
    }

    private boolean isLateUploadScheduleOptionConfigured() throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        String uploadSchedule = LateExternalUploadScheduleOption.getUploadSchedule((ServerOptionIndex)serverOptionIndex);
        return !StringUtils.isEmpty((String)uploadSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(CommitDescriptor commit, boolean targetsExternalStorage) throws StorageException {
        if (targetsExternalStorage) {
            StoreAnalysisResultsInExternalStorageTrigger.schedule((InternalProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer(), (String)DATA_UPLOADED_SCHEDULING_REASON);
            return;
        }
        Lock lock = this.serviceInfo.getLockProvider().obtainLock(IntegrateImportedAnalysisResultsTrigger.class.getName());
        lock.lock();
        try {
            if (!DelayedExternalUploadIntegrationTrigger.isIntegrateTriggerAlreadyScheduled((CommitDescriptor)commit, (IndexLayer)this.serviceInfo.getIndexLayer(), (InternalProjectId)this.serviceInfo.getInternalId())) {
                JobDescriptor job = JobDescriptor.forProject((InternalProjectId)this.serviceInfo.getInternalId()).withPrivilegedTrigger(IntegrateImportedAnalysisResultsTrigger.class).withSchedulingReason(DATA_UPLOADED_SCHEDULING_REASON).withCommit((ISchedulingCommit)ISchedulingCommit.plain((CommitDescriptor)commit)).build();
                ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), job);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void storeStatus(ExternalAnalysisStatusIndex statusIndex, ExternalAnalysisSessionInfo session, boolean success) throws StorageException {
        if (session == null) {
            LOGGER.error("Failed to store status as no session was created before the first error!");
            return;
        }
        statusIndex.runWithLock(lockedIndex -> this.storeStatus((ExternalAnalysisStatusIndex.LockedIndexAccess)lockedIndex, session, success, session.getCommit()));
    }

    private void storeStatus(ExternalAnalysisStatusIndex.LockedIndexAccess lockedIndexAccess, ExternalAnalysisSessionInfo session, boolean success, CommitDescriptor sessionCommit) throws StorageException {
        ExternalAnalysisStatusInfo oldStatus = lockedIndexAccess.getStatus(sessionCommit);
        ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy((ExternalAnalysisStatusInfo)oldStatus, () -> {
            ExternalAnalysisStatusInfo created = new ExternalAnalysisStatusInfo(sessionCommit, true, session.getUploadTimestamp(), session.getTargetStorage().isPresent());
            created.addPartition(session.getPartition());
            return created;
        });
        status.setMessage(session.getMessage());
        ExternalAnalysisProcessingStepInfo step = new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.UPLOADED, success);
        step.addMessages(this.logManager.getProcessingMessages());
        status.addProcessingStep(step);
        lockedIndexAccess.updateStatusWithKnownOldStatus(oldStatus, status);
    }

    private static void checkParameters(ExternalAnalysisSessionInfo sessionInfo, SessionBasedExternalAnalysisServiceQueryOptions parameters) {
        String uploadMessage = parameters.getUploadMessage();
        if (uploadMessage != null && !uploadMessage.equals("External analysis data upload") && !parameters.getUploadMessage().equals(sessionInfo.getMessage())) {
            throw new BadRequestException("Provided upload message is different from the one used to create the session! Either provide the same upload message or skip it.");
        }
        String partition = parameters.getPartition();
        if (partition != null && !partition.equals(sessionInfo.getPartition())) {
            throw new BadRequestException("Provided partition name is different from the one used to create the session! Either provide the same partition name or skip it." + String.format("'%s' vs  '%s'", partition, sessionInfo.getPartition()));
        }
    }

    protected void requirePartition(S parameters) throws BadRequestException {
        if (((SessionBasedExternalAnalysisServiceQueryOptions)parameters).getPartition() == null) {
            throw new BadRequestException("Partition name must be provided.");
        }
    }
}

