/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.status;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/external-analysis/reports")
public class ExternalAnalysisReportArchiveService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Path(value="{commit}/{reportIndex}")
    @Operation(summary="Download report", description="Returns a file download of the requested archived report. The report index information is part of the external analysis status details.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response downloadReport(@PathParam(value="commit") UnresolvedCommitDescriptor unresolvedCommit, @PathParam(value="reportIndex") int reportIndex) throws StorageException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        ExternalAnalysisReportArchiveIndex reportArchiveIndex = this.openProjectIndex(ExternalAnalysisReportArchiveIndex.class, null);
        List reportArchiveInfos = reportArchiveIndex.getReportArchiveInfos(commit);
        if (reportArchiveInfos == null) {
            throw new NotFoundException("No meta information stored for the requested upload commit");
        }
        if (reportArchiveInfos.size() <= reportIndex) {
            throw new NotFoundException("No report stored at the requested index");
        }
        String report = reportArchiveIndex.getReport(commit, reportIndex);
        if (report == null) {
            throw new NotFoundException("Could not retrieve report content");
        }
        String fileName = reportArchiveInfos.stream().filter(archivedReport -> archivedReport.getReportIndex() == reportIndex).findFirst().orElseThrow(() -> new NotFoundException("Could not retrieve report file name")).getFilename();
        return ResponseUtils.getFileDownloadResponse((Object)report, (MediaType)MediaType.TEXT_PLAIN_TYPE, (String)fileName);
    }

    @GET
    @Path(value="{commit}/download")
    @Operation(summary="Download all archived external reports as ZIP archive", description="Returns a ZIP download of all archived external reports.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"application/zip"})
    public Response downloadAllExternalReportsAsZip(@PathParam(value="commit") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        ExternalAnalysisReportArchiveIndex reportArchiveIndex = this.openProjectIndex(ExternalAnalysisReportArchiveIndex.class, null);
        List reportArchiveInfos = reportArchiveIndex.getReportArchiveInfos(commit);
        if (reportArchiveInfos == null) {
            throw new NotFoundException("No meta information stored for the requested upload commit");
        }
        StreamingOutput streamingOutput = ExternalAnalysisReportArchiveService.createStreamingOutputOfAllExternalReports(reportArchiveInfos, reportArchiveIndex, commit);
        return ResponseUtils.getFileDownloadResponse((Object)streamingOutput, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)("ts-ext-analysis-reports_" + commit.getTimestamp() + "_" + commit.getBranchName() + "_" + reportArchiveIndex.getName() + ".zip"));
    }

    private static StreamingOutput createStreamingOutputOfAllExternalReports(List<ExternalAnalysisReportArchiveInfo> externalAnalysisReportArchiveInfos, ExternalAnalysisReportArchiveIndex externalAnalysisReportArchiveIndex, CommitDescriptor commitDescriptor) {
        return output -> {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(output));){
                ExternalAnalysisReportArchiveService.addAllExternalReportsToZipOutputStream(zipOutputStream, externalAnalysisReportArchiveIndex, externalAnalysisReportArchiveInfos, commitDescriptor);
            }
        };
    }

    private static void addAllExternalReportsToZipOutputStream(ZipOutputStream zipOutputStream, ExternalAnalysisReportArchiveIndex externalAnalysisReportArchiveIndex, List<ExternalAnalysisReportArchiveInfo> externalAnalysisReportArchiveInfos, CommitDescriptor commitDescriptor) {
        for (ExternalAnalysisReportArchiveInfo reportArchiveInfo : externalAnalysisReportArchiveInfos) {
            try {
                String report = externalAnalysisReportArchiveIndex.getReport(commitDescriptor, reportArchiveInfo.getReportIndex());
                ExternalAnalysisReportArchiveService.addZipArchiveEntryForExternalReportToZipOutputStream(zipOutputStream, report, reportArchiveInfo.getFilename());
            }
            catch (IOException | StorageException e) {
                LOGGER.warn("Skipped external report download, could not retrieve content of {} from index for commit {}", (Object)reportArchiveInfo.getFilename(), (Object)commitDescriptor);
            }
        }
    }

    private static void addZipArchiveEntryForExternalReportToZipOutputStream(ZipOutputStream zipOutputStream, String reportContent, String reportFileName) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(reportContent.getBytes(StandardCharsets.UTF_8));){
            zipOutputStream.putNextEntry(new ZipEntry(reportFileName));
            IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }
}

