/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.upload.roslyn.data.RoslynAnalysisToolRun;
import com.teamscale.index.upload.roslyn.data.RoslynReport;
import com.teamscale.index.upload.roslyn.data.RoslynRule;
import com.teamscale.service.findings.FindingDescriptorCreationServiceBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/external-findings/descriptions/from-roslyn-report")
public class CustomRoslynFindingDescriptorCreationService
extends FindingDescriptorCreationServiceBase<RoslynRule> {
    private static final String DESCRIPTION = "Given a Roslyn findings report in the payload, this service creates or updates external finding descriptors, updates the specified analysis profile by adding the rules from the report to the analysis profile. In addition, the finding schema of all projects referencing the profile are updated.";

    @POST
    @Operation(summary="Create or update external finding descriptors from a Roslyn report.", description="Given a Roslyn findings report in the payload, this service creates or updates external finding descriptors, updates the specified analysis profile by adding the rules from the report to the analysis profile. In addition, the finding schema of all projects referencing the profile are updated.", tags={"Findings"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.EDIT}, entityQueryParameter="analysis-profile")
    @Consumes(value={"multipart/form-data"})
    public void createCustomRoslynFindingDescriptor(@Parameter(description="The name of the analysis profile to be updated. It cannot be null.", required=true) @QueryParam(value="analysis-profile") String analysisProfileName, @Parameter(description="Given a Roslyn findings report in the payload, this service creates or updates external finding descriptors, updates the specified analysis profile by adding the rules from the report to the analysis profile. In addition, the finding schema of all projects referencing the profile are updated.", array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="report") List<FormDataBodyPart> reports) throws ConQATException, ProjectConfigurationException, IOException {
        this.doProcess(reports, analysisProfileName);
    }

    @Override
    protected EAnalysisTool getTool() {
        return EAnalysisTool.ROSLYN;
    }

    @Override
    protected void parseReport(String report, Map<String, RoslynRule> rulesById) throws ConQATException {
        RoslynReport roslynReport = (RoslynReport)JsonUtils.deserializeFromJsonWithNullCheck((String)report, RoslynReport.class);
        for (RoslynAnalysisToolRun run : roslynReport.getRuns()) {
            if (run.getRules() == null) continue;
            rulesById.putAll(run.getRules());
        }
    }
}

