/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.service.findings.FindingChurnByIssueServiceBase;
import com.teamscale.service.findings.FindingChurnListDto;
import com.teamscale.service.findings.FindingChurnTruncationParameter;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/issues/{issueId}/finding-churn")
public class IssueFindingChurnService
extends FindingChurnByIssueServiceBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Get issue finding churn", description="Determines an aggregated finding churn across all commits of the issue.", responses={@ApiResponse(responseCode="404", description="Issue could not be found"), @ApiResponse(responseCode="409", description="Multiple issues for the provided ID found")}, tags={"Issues", "Findings"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public FindingChurnListDto getIssueFindingChurn(@Parameter(description="ID of the issue to determine the finding churn for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.", required=true) @PathParam(value="issueId") String issueId, @Parameter(description="If set, findings that have already been resolved will not be included in the result") @QueryParam(value="exclude-resolved-findings") boolean excludeResolvedFindings, @Parameter(description="If set, findings that have been flagged as tolerated or false-positives will not be included in the result") @QueryParam(value="exclude-flagged-findings") boolean excludeFlaggedFindings, @BeanParam FindingChurnTruncationParameter truncationParameter) throws StorageException {
        FindingChurnList findingChurn = this.getFindingChurn(issueId, excludeFlaggedFindings, excludeResolvedFindings);
        return truncationParameter.truncated(FindingChurnListDto.of(findingChurn));
    }
}

